/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.driver;

import java.util.HashMap;
import org.eclipse.persistence.tools.db.driver.DB2;
import org.eclipse.persistence.tools.db.driver.Derby;
import org.eclipse.persistence.tools.db.driver.HSQLDB;
import org.eclipse.persistence.tools.db.driver.Informix;
import org.eclipse.persistence.tools.db.driver.MaxDB;
import org.eclipse.persistence.tools.db.driver.MySQL;
import org.eclipse.persistence.tools.db.driver.Oracle;
import org.eclipse.persistence.tools.db.driver.PostgreSQL;
import org.eclipse.persistence.tools.db.driver.SQLServer;
import org.eclipse.persistence.tools.db.driver.Sybase;
import org.eclipse.persistence.tools.db.driver.Unknown;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterFactory;
import org.eclipse.persistence.tools.gen.db.Database;

public class WorkbenchDriverAdapterManager {
    private final HashMap<String, WorkbenchDriverAdapterFactory> adapterFactories = this.buildAdapterFactories();
    private static final WorkbenchDriverAdapterFactory UNRECOGNIZED_ADAPTER_FACTORY = new Unknown.Factory();
    private static final WorkbenchDriverAdapterManager INSTANCE = new WorkbenchDriverAdapterManager();

    public static WorkbenchDriverAdapterManager instance() {
        return INSTANCE;
    }

    private WorkbenchDriverAdapterManager() {
    }

    private HashMap<String, WorkbenchDriverAdapterFactory> buildAdapterFactories() {
        HashMap<String, WorkbenchDriverAdapterFactory> factories = new HashMap<String, WorkbenchDriverAdapterFactory>();
        this.addAdapterFactoriesTo(factories);
        return factories;
    }

    private void addAdapterFactoriesTo(HashMap<String, WorkbenchDriverAdapterFactory> factories) {
        this.addAdapterFactoryTo(new DB2.Factory(), factories);
        this.addAdapterFactoryTo(new Derby.Factory(), factories);
        this.addAdapterFactoryTo(new HSQLDB.Factory(), factories);
        this.addAdapterFactoryTo(new Informix.Factory(), factories);
        this.addAdapterFactoryTo(new MaxDB.Factory(), factories);
        this.addAdapterFactoryTo(new MySQL.Factory(), factories);
        this.addAdapterFactoryTo(new Oracle.Factory(), factories);
        this.addAdapterFactoryTo(new PostgreSQL.Factory(), factories);
        this.addAdapterFactoryTo(new SQLServer.Factory(), factories);
        this.addAdapterFactoryTo(new Sybase.Factory(), factories);
    }

    private void addAdapterFactoryTo(WorkbenchDriverAdapterFactory factory, HashMap<String, WorkbenchDriverAdapterFactory> factories) {
        String[] stringArray = factory.getSupportedVendors();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addAdapterFactoryTo(name, factory, factories);
            ++n2;
        }
    }

    private void addAdapterFactoryTo(String name, WorkbenchDriverAdapterFactory factory, HashMap<String, WorkbenchDriverAdapterFactory> factories) {
        if (factories.put(name, factory) != null) {
            throw new IllegalArgumentException("Duplicate adapter factory: " + name);
        }
    }

    public WorkbenchDriverAdapter buildAdapter(String dtpVendorName, Database database) {
        return this.getAdapterFactory(dtpVendorName).buildAdapter(database);
    }

    private WorkbenchDriverAdapterFactory getAdapterFactory(String dtpVendorName) {
        WorkbenchDriverAdapterFactory factory = this.adapterFactories.get(dtpVendorName);
        return factory != null ? factory : UNRECOGNIZED_ADAPTER_FACTORY;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

