/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.filter.Filter;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModelWrapper;

public class FilteringPropertyValueModel<V>
extends PropertyValueModelWrapper<V>
implements PropertyValueModel<V> {
    protected final Filter<V> filter;
    protected final V defaultValue;

    public FilteringPropertyValueModel(PropertyValueModel<? extends V> valueModel, Filter<V> filter) {
        this(valueModel, filter, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel<? extends V> valueModel, Filter<V> filter, V defaultValue) {
        super(valueModel);
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
        this.defaultValue = defaultValue;
    }

    @Override
    public V getValue() {
        return this.filterValue(this.valueModel.getValue());
    }

    @Override
    protected void wrappedValueChanged(V oldValue, V newValue) {
        this.firePropertyChanged("value", this.filterValue(oldValue), this.filterValue(newValue));
    }

    protected V filterValue(V value) {
        return this.filter.accept(value) ? value : this.getDefaultValue();
    }

    protected V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

