/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.reference;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.reference.ModifiableObjectReference;

public class SimpleObjectReference<V>
implements ModifiableObjectReference<V>,
Cloneable,
Serializable {
    private volatile V value;
    private static final long serialVersionUID = 1L;

    public SimpleObjectReference(V value) {
        this.value = value;
    }

    public SimpleObjectReference() {
        this(null);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean valueEquals(Object object) {
        return ObjectTools.equals(this.value, object);
    }

    @Override
    public boolean valueNotEqual(Object object) {
        return ObjectTools.notEquals(this.value, object);
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isNotNull() {
        return this.value != null;
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public V setNull() {
        return this.setValue(null);
    }

    public SimpleObjectReference<V> clone() {
        try {
            SimpleObjectReference clone = (SimpleObjectReference)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

