/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.iterable;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterable.PeekableIterable;
import org.eclipse.persistence.tools.utility.iterator.PeekableIterator;


@SuppressWarnings("nls")
public class PeekableIterableTests extends TestCase {

	public PeekableIterableTests(String name) {
		super(name);
	}

	public void testIterator() {
		PeekableIterable<String> iterable = this.buildIterable();
		PeekableIterator<String> iterator = iterable.iterator();
		assertEquals("one", iterator.peek());
	}

	public void testToString() {
		assertNotNull(this.buildIterable().toString());
	}

	private PeekableIterable<String> buildIterable() {
		return new PeekableIterable<String>(this.buildNestedIterable());
	}

	private Iterable<String> buildNestedIterable() {
		return new ArrayIterable<String>(this.buildArray());
	}

	private String[] buildArray() {
		return new String[] {"one", "two", "three"};
	}
}