/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ExceptionHandler;

/**
 * @see AbstractSafeCommandExecutor
 */
public class SafeExtendedCommandExecutor
	extends AbstractSafeCommandExecutor<ExtendedCommandExecutor>
	implements ExtendedCommandExecutor
{
	/**
	 * <strong>NB:</strong> The default exception handler simply
	 * <em>ignores</em> any and all exceptions.
	 */
	public SafeExtendedCommandExecutor() {
		this(ExtendedCommandExecutor.Default.instance());
	}

	/**
	 * <strong>NB:</strong> The default exception handler simply
	 * <em>ignores</em> any and all exceptions.
	 */
	public SafeExtendedCommandExecutor(ExtendedCommandExecutor commandExecutor) {
		super(commandExecutor);
	}

	public SafeExtendedCommandExecutor(ExceptionHandler exceptionHandler) {
		this(ExtendedCommandExecutor.Default.instance(), exceptionHandler);
	}

	public SafeExtendedCommandExecutor(ExtendedCommandExecutor commandExecutor, ExceptionHandler exceptionHandler) {
		super(commandExecutor, exceptionHandler);
	}

	@Override
	public void waitToExecute(Command command) throws InterruptedException {
		try {
			this.commandExecutor.waitToExecute(command);
		} catch (Throwable ex) {
			this.exceptionHandler.handleException(ex);
		}
	}

	@Override
	public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
		try {
			return this.commandExecutor.waitToExecute(command, timeout);
		} catch (Throwable ex) {
			this.exceptionHandler.handleException(ex);
			return true;  // hmmm... seems like we get here only if the command executed
		}
	}
}