/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * A <code>ReadOnlyListIterator</code> wraps another
 * {@link ListIterator} and removes support for:<ul>
 * <li>{@link #remove()}
 * 	<li>{@link #set(Object)}
 * 	<li>{@link #add(Object)}
 * </ul>
 *
 * @param <E> the type of elements returned by the list iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyListIterable
 */
public class ReadOnlyListIterator<E>
	implements ListIterator<E>
{
	private final ListIterator<? extends E> listIterator;


	/**
	 * Construct a list iterator on the specified list that
	 * disallows removes, sets, and adds.
	 */
	public ReadOnlyListIterator(List<? extends E> list) {
		this(list.listIterator());
	}

	/**
	 * Construct a list iterator on the specified list that
	 * disallows removes, sets, and adds.
	 */
	public ReadOnlyListIterator(ListIterable<? extends E> listIterable) {
		this(listIterable.iterator());
	}

	/**
	 * Construct a list iterator on the specified list iterator that
	 * disallows removes, sets, and adds.
	 */
	public ReadOnlyListIterator(ListIterator<? extends E> listIterator) {
		super();
		if (listIterator == null) {
			throw new NullPointerException();
		}
		this.listIterator = listIterator;
	}

	@Override
	public boolean hasNext() {
		// delegate to the nested iterator
		return this.listIterator.hasNext();
	}

	@Override
	public E next() {
		// delegate to the nested iterator
		return this.listIterator.next();
	}

	@Override
	public boolean hasPrevious() {
		// delegate to the nested iterator
		return this.listIterator.hasPrevious();
	}

	@Override
	public E previous() {
		// delegate to the nested iterator
		return this.listIterator.previous();
	}

	@Override
	public int nextIndex() {
		// delegate to the nested iterator
		return this.listIterator.nextIndex();
	}

	@Override
	public int previousIndex() {
		// delegate to the nested iterator
		return this.listIterator.previousIndex();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void set(E o) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void add(E o) {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.listIterator);
	}
}