/*******************************************************************************
 * Copyright (c) 2009, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

/**
 * Catalog strategy for DTP database drivers that build a "virtual" catalog. Returns any catalogs
 * (e.g. Oracle). This catalog cannot be specified by the user in annotations etc.
 *
 * @see java.sql.DatabaseMetaData#getCatalogs()
 *
 * @version 2.5
 */
class FauxCatalogStrategy implements CatalogStrategy {

	FauxCatalogStrategy() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean supportsCatalogs() {
		return false;
	}
}