/*******************************************************************************
 * Copyright (c) 2009, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.persistence.tools.db.driver;

import org.eclipse.persistence.tools.gen.db.Database;

/**
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
class Unknown extends AbstractWorkbenchDriverAdapter {

	Unknown(Database database) {
		super(database);
	}

	@Override
	CatalogStrategy buildCatalogStrategy() {
		// infer from existing catalogs and schemas
	//	return new UnknownCatalogStrategy(this.database.getDTPDatabase());
		throw new UnsupportedOperationException("Unrecognized DB not yet supported!");
	}

	@Override
	FoldingStrategy buildFoldingStrategy() {
		// SQL standard
		return UpperCaseFoldingStrategy.instance();
	}

	// ********** factory **********

	static class Factory implements WorkbenchDriverAdapterFactory {
		@Override
		public String[] getSupportedVendors() {
			throw new UnsupportedOperationException();
		}
		@Override
		public WorkbenchDriverAdapter buildAdapter(Database database) {
			return new Unknown(database);
		}
	}
}