/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalTimeOfDay;

/**
 * The external form of a time of day, which is a child of an cache.
 *
 * @see Cache
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class TimeOfDay extends AbstractExternalForm
                      implements ExternalTimeOfDay {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String EXPIRY_TIME_OF_DAY = "expiry-time-of-day";

	/**
	 * The attribute name used to store and retrieve the hour property.
	 */
	static final String HOUR = "hour";

	/**
	 * The attribute name used to store and retrieve the millisecond property.
	 */
	static final String MILLISECOND = "millisecond";

	/**
	 * The attribute name used to store and retrieve the minute property.
	 */
	static final String MINUTE = "minute";

	/**
	 * The attribute name used to store and retrieve the second property.
	 */
	static final String SECOND = "second";

	/**
	 * Creates a new <code>TimeOfDay</code>.
	 *
	 * @param parent The parent of this external form
	 */
	TimeOfDay(Cache parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(HOUR);
		names.add(MINUTE);
		names.add(SECOND);
		names.add(MILLISECOND);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return EXPIRY_TIME_OF_DAY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getHour() {
		return getIntegerAttribute(HOUR);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMillisecond() {
		return getIntegerAttribute(MILLISECOND);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMinute() {
		return getIntegerAttribute(MINUTE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getSecond() {
		return getIntegerAttribute(SECOND);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setHour(Integer hour) {
		setAttribute(HOUR, hour);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMillisecond(Integer millisecond) {
		setAttribute(MILLISECOND, millisecond);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMinute(Integer minute) {
		setAttribute(MINUTE, minute);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSecond(Integer second) {
		setAttribute(SECOND, second);
	}
}