/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingStringException;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ResourceBundleStringRepository
implements StringRepository {
    private ResourceBundle resourceBundle;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];

    public ResourceBundleStringRepository(String resourceClassName) {
        this.initialize(resourceClassName);
    }

    public ResourceBundleStringRepository(Class resourceClass) {
        this(resourceClass.getName());
    }

    protected void initialize(String resourceClassName) {
        this.resourceBundle = ResourceBundle.getBundle(resourceClassName);
        this.validate(this.resourceBundle);
    }

    protected void validate(ResourceBundle bundle) {
        if (bundle instanceof ListResourceBundle) {
            this.validate((ListResourceBundle)bundle);
        }
    }

    protected void validate(ListResourceBundle bundle) {
        Object[][] contents = (Object[][])ClassTools.invokeMethod((Object)bundle, (String)"getContents");
        HashBag keys = new HashBag(contents.length);
        int i = contents.length;
        while (i-- > 0) {
            String key = (String)contents[i][0];
            if (keys.contains(key)) {
                throw new IllegalStateException("duplicate resource key: " + key);
            }
            keys.add(key);
        }
    }

    @Override
    public boolean hasString(String key) {
        return key == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)key);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, EMPTY_ARGUMENTS);
    }

    @Override
    public String getString(String key, Object argument) {
        return this.getString(key, new Object[]{argument});
    }

    @Override
    public String getString(String key, Object argument1, Object argument2) {
        return this.getString(key, new Object[]{argument1, argument2});
    }

    @Override
    public String getString(String key, Object argument1, Object argument2, Object argument3) {
        return this.getString(key, new Object[]{argument1, argument2, argument3});
    }

    @Override
    public String getString(String key, Object[] arguments) {
        return this.format(this.get(key), arguments);
    }

    protected String get(String key) {
        if (key == null) {
            return "";
        }
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            if (ex.getKey().equals(key)) {
                throw new MissingStringException("Missing string: " + key, key);
            }
            throw ex;
        }
    }

    protected String format(String string, Object[] arguments) {
        return string;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

