/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

public final class AutomapAction
extends AbstractEnablableFrameworkAction {
    public AutomapAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("AUTOMAP_ACTION");
        this.initializeToolTipText("AUTOMAP_ACTION.TOOLTIP");
        this.initializeIcon("automap");
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return ((MappingsApplicationNode)selectedNode).isAutoMappable();
    }

    @Override
    protected void execute() {
        ApplicationNode[] projectNodes = this.selectedProjectNodes();
        for (int i = 0; i < projectNodes.length; ++i) {
            this.execute((ProjectNode)projectNodes[i]);
        }
    }

    private void execute(ProjectNode projectNode) {
        if (projectNode.canAutomapDescriptors()) {
            projectNode.getProject().automap(this.selectedDescriptorsFor(projectNode));
            this.showResults(this.prepareResults(this.selectedNodesFor(projectNode)));
        } else {
            this.showError(projectNode.getCannotAutomapDescriptorsStringKey());
        }
    }

    private Collection selectedDescriptorsFor(ProjectNode projectNode) {
        HashSet descriptors = new HashSet();
        for (MappingsApplicationNode node : this.selectedNodesFor(projectNode)) {
            if (node.getProjectNode() != projectNode) continue;
            node.addDescriptorsTo(descriptors);
        }
        return descriptors;
    }

    private Collection selectedNodesFor(ProjectNode projectNode) {
        ArrayList<MappingsApplicationNode> result = new ArrayList<MappingsApplicationNode>();
        ApplicationNode[] nodes = this.selectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            MappingsApplicationNode node = (MappingsApplicationNode)nodes[i];
            if (node.getProjectNode() != projectNode) continue;
            result.add(node);
        }
        return result;
    }

    private Collection prepareResults(Collection nodes) {
        ArrayList<StatusDialog.Status> status = new ArrayList<StatusDialog.Status>(nodes.size());
        for (ApplicationNode node : nodes) {
            MWError error = this.buildError(node);
            LinkedHashMap<MWError, MWError> errors = new LinkedHashMap<MWError, MWError>();
            errors.put(error, error);
            StatusDialog.Status modelStatus = StatusDialog.createStatus((Object)node, errors);
            status.add(modelStatus);
        }
        return status;
    }

    private MWError buildError(ApplicationNode node) {
        return new MWError(((AutomappableNode)((Object)node)).getAutomapSuccessfulStringKey(), (Object)node.displayString());
    }

    private void showResults(Collection status) {
        StatusDialog dialog = new StatusDialog(this.getWorkbenchContext(), status, "AUTOMAP_STATUS_DIALOG_TITLE", "dialog.automap"){

            @Override
            protected CellRendererAdapter buildNodeRenderer(Object value) {
                return value instanceof ApplicationNode ? this.buildApplicationNodeAdapter() : super.buildNodeRenderer(value);
            }

            private CellRendererAdapter buildApplicationNodeAdapter() {
                return new AbstractCellRendererAdapter(){

                    @Override
                    public String buildAccessibleName(Object value) {
                        return ((ApplicationNode)value).accessibleName();
                    }

                    @Override
                    public Icon buildIcon(Object value) {
                        return ((ApplicationNode)value).icon();
                    }

                    @Override
                    public String buildText(Object value) {
                        return ((ApplicationNode)value).displayString();
                    }
                };
            }
        };
        dialog.setVisible(true);
    }

    private void showError(String errorKey) {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString(errorKey), this.resourceRepository().getString(errorKey + ".title"), 2);
    }
}

