/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class ReportQueryAttributeDialog
extends AttributeItemDialog {
    private JComboBox functionComboBox = new JComboBox(this.buildFunctionComboBoxModel());
    private JTextField itemNameTextField = new JTextField();

    ReportQueryAttributeDialog(MWReportQuery query, MWReportAttributeItem attributeItem, WorkbenchContext context) {
        super((MWQuery)query, (MWAttributeItem)attributeItem, context);
    }

    @Override
    protected String helpTopicId() {
        return "descriptor.queryManager.report.attributes";
    }

    @Override
    protected String titleKey() {
        return "REPORT_QUERY_ATTRIBUTES_DIALOG_TITLE";
    }

    @Override
    protected String editTitleKey() {
        return "REPORT_QUERY_ATTRIBUTES_EDIT_DIALOG_TITLE";
    }

    @Override
    protected Filter buildChooseableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isValidForReportQueryAttribute();
            }
        };
    }

    @Override
    protected Filter buildTraversableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isTraversableForReportQueryAttribute();
            }
        };
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        QueryableTree queryableTree = this.buildQueryableTree();
        JScrollPane scrollPane = new JScrollPane(queryableTree);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)scrollPane, constraints);
        JLabel functionLabel = SwingComponentFactory.buildLabel("FUNCTION_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)functionLabel, constraints);
        this.functionComboBox.setEditable(true);
        this.functionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReportQueryAttributeDialog.this.updateOKButton();
                ReportQueryAttributeDialog.this.calculateItemName();
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)this.functionComboBox, constraints);
        functionLabel.setLabelFor(this.functionComboBox);
        JLabel itemNameLabel = SwingComponentFactory.buildLabel("ATTRIBUTE_ITEM_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)itemNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)this.itemNameTextField, constraints);
        itemNameLabel.setLabelFor(this.itemNameTextField);
        return panel;
    }

    private ComboBoxModel buildFunctionComboBoxModel() {
        return new DefaultComboBoxModel<String>(MWReportAttributeItem.FUNCTIONS);
    }

    String getFunction() {
        return (String)this.functionComboBox.getSelectedItem();
    }

    String getItemName() {
        return this.itemNameTextField.getText();
    }

    @Override
    protected void initializeEditMode(MWAttributeItem attributeItem) {
        super.initializeEditMode(attributeItem);
        this.functionComboBox.setSelectedItem(((MWReportAttributeItem)attributeItem).getFunction());
        this.itemNameTextField.setText(((MWReportAttributeItem)attributeItem).getName());
    }

    @Override
    protected void treeSelectionChanged(TreeSelectionEvent e) {
        super.treeSelectionChanged(e);
        this.calculateItemName();
    }

    @Override
    protected void updateOKButton() {
        if (this.getFunction() == "Count" && this.getQueryableTree().getSelectionCount() == 0) {
            this.getOKAction().setEnabled(true);
            return;
        }
        super.updateOKButton();
    }

    private void calculateItemName() {
        TreePath selectionPath = this.getQueryableTree().getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        QueryableTreeNode selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
        MWQueryable queryableObject = selectedNode.getQueryable();
        String suggestedItemName = queryableObject.getName();
        selectionPath = selectionPath.getParentPath();
        while (selectionPath.getPathCount() > 1) {
            selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
            MWQueryable joinedQueryable = selectedNode.getQueryable();
            suggestedItemName = joinedQueryable.getName() + suggestedItemName;
            selectionPath = selectionPath.getParentPath();
        }
        if (this.getFunction() != "None") {
            suggestedItemName = suggestedItemName + this.getFunction();
        }
        this.itemNameTextField.setText(suggestedItemName);
    }

    @Override
    protected int attributeItemsSize() {
        return ((MWReportQuery)this.getQuery()).attributeItemsSize();
    }

    @Override
    protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
        return ((MWReportQuery)this.getQuery()).indexOfAttributeItem((MWReportAttributeItem)attributeItem);
    }

    @Override
    protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
        MWReportAttributeItem attributeItem = ((MWReportQuery)this.getQuery()).addAttributeItem(index, this.getItemName(), queryables, allowsNulls);
        attributeItem.setFunction(this.getFunction());
    }

    @Override
    protected void removeAttributeItem(int index) {
        ((MWReportQuery)this.getQuery()).removeAttributeItem(index);
    }

    @Override
    protected boolean preConfirm() {
        TreePath selectionPath = this.getQueryableTree().getSelectionPath();
        if (selectionPath == null) {
            if (this.getFunction() != "Count") {
                throw new IllegalStateException("Must select an item from the tree unless the chosen funciton is Count");
            }
            MWReportAttributeItem item = ((MWReportQuery)this.getQuery()).addAttributeItem(null, (MWQueryable)null);
            item.setFunction(this.getFunction());
            return true;
        }
        return super.preConfirm();
    }
}

