/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMappingHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWAggregatePathToColumn
extends MWModel {
    private List mappingHandles;
    private volatile AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator;
    public static final String AGGREGATE_RUNTIME_FIELD_NAME_GENERATOR_PROPERTY = "aggregateRuntimeFieldNameGenerator";
    private volatile String fieldDescription;
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";

    private MWAggregatePathToColumn() {
    }

    MWAggregatePathToColumn(MWAggregateMapping mapping) {
        super(mapping);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.mappingHandles = new Vector();
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged(COLUMN_PROPERTY, old, column);
    }

    public AggregateRuntimeFieldNameGenerator getAggregateRuntimeFieldNameGenerator() {
        return this.aggregateRuntimeFieldNameGenerator;
    }

    public void setAggregateRuntimeFieldNameGenerator(AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator) {
        this.aggregateRuntimeFieldNameGenerator = aggregateRuntimeFieldNameGenerator;
    }

    void addMappingNode(MWMapping node) {
        if (this.getMappingNodes().contains(node)) {
            return;
        }
        this.mappingHandles.add(new MWMappingHandle(this, node, MWHandle.NodeReferenceScrubber.NULL_INSTANCE));
    }

    private void addMappingAt(int index, MWMapping mapping) {
        this.mappingHandles.add(index, new MWMappingHandle(this, mapping, MWHandle.NodeReferenceScrubber.NULL_INSTANCE));
    }

    MWAggregatePathToColumn copy(MWAggregateMapping parent) {
        MWAggregatePathToColumn copy = new MWAggregatePathToColumn(parent);
        Iterator stream = this.getMappingNodes().iterator();
        while (stream.hasNext()) {
            copy.addMappingNode((MWMapping)stream.next());
        }
        copy.setAggregateRuntimeFieldNameGenerator(this.getAggregateRuntimeFieldNameGenerator());
        copy.setColumn(this.columnHandle.getColumn());
        return copy;
    }

    MWMapping mappingAt(int mappingIndex) {
        return (MWMapping)this.getMappingNodes().get(mappingIndex);
    }

    List getMappingNodes() {
        Vector<MWMapping> result = new Vector<MWMapping>(this.mappingHandles.size());
        CloneIterator stream = new CloneIterator(this.mappingHandles);
        while (stream.hasNext()) {
            result.add(((MWMappingHandle)stream.next()).getMapping());
        }
        return result;
    }

    void insertRootMappingNode(MWMapping node) {
        this.addMappingAt(0, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.mappingHandles;
        synchronized (list) {
            children.addAll(this.mappingHandles);
        }
        children.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWAggregatePathToColumn.this.setColumn(null);
            }

            public String toString() {
                return "MWAggregatePathToColumn.buildColumnScrubber()";
            }
        };
    }

    @Override
    public void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
        super.mappingReplaced(oldMapping, newMapping);
    }

    boolean isPathReadOnly() {
        for (MWMapping mapping : this.getMappingNodes()) {
            if (!mapping.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    boolean fieldIsWritten() {
        if (this.isPathReadOnly()) {
            return false;
        }
        return this.aggregateRuntimeFieldNameGenerator.fieldIsWritten();
    }

    public String getPathDescription() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterator i = this.getMappingNodes().iterator();
        if (i.hasNext()) {
            pw.print(this.mappingAt(0).getParentDescriptor().getMWClass().shortName());
        } else {
            pw.print(this.aggregateRuntimeFieldNameGenerator.owningDescriptor().getMWClass().shortName());
        }
        while (i.hasNext()) {
            pw.print(".");
            pw.print(((MWMapping)i.next()).getName());
        }
        return sw.getBuffer().toString();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getPathDescription());
        sb.append(" -> ");
        if (this.getColumn() == null) {
            sb.append("null");
        } else {
            sb.append(this.getColumn().qualifiedName());
        }
    }

    public String description() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public int compareTo(Object o) {
        MWAggregatePathToColumn otherPathFieldAssociation = (MWAggregatePathToColumn)o;
        return Collator.getInstance().compare(this.getPathDescription() + this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime(), otherPathFieldAssociation.getPathDescription() + otherPathFieldAssociation.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime());
    }

    private MWAggregateMapping getAggregateMapping() {
        return (MWAggregateMapping)this.getParent();
    }

    private MWRelationalDescriptor getParentDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getAggregateMapping().getParentDescriptor());
    }

    void adjustRuntimeMapping(AggregateObjectMapping runtimeMapping) {
        if (!this.getParentDescriptor().isAggregateDescriptor()) {
            if (this.getColumn() != null) {
                runtimeMapping.addFieldNameTranslation(this.getColumn().qualifiedName(), this.calculateAggregateFieldName());
            }
        } else {
            runtimeMapping.addFieldNameTranslation(this.calculateSourceFieldName(), this.calculateAggregateFieldName());
        }
    }

    private String calculateAggregateFieldName() {
        String fieldName = "";
        ListIterator mappingNodes = this.getMappingNodes().listIterator();
        while (mappingNodes.hasNext()) {
            MWMapping mapping = (MWMapping)mappingNodes.next();
            if (fieldName.equals("")) {
                fieldName = fieldName + mapping.getName();
                continue;
            }
            fieldName = fieldName + "_" + mapping.getName();
        }
        if (!fieldName.equals("")) {
            fieldName = fieldName + "->";
        }
        fieldName = fieldName + this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime();
        return fieldName;
    }

    private String calculateSourceFieldName() {
        return ((MWAggregateMapping)this.getParent()).getName() + "_" + this.calculateAggregateFieldName();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAggregatePathToColumn.class);
        XMLDirectMapping fieldDescriptionMapping = new XMLDirectMapping();
        fieldDescriptionMapping.setAttributeName(AGGREGATE_RUNTIME_FIELD_NAME_GENERATOR_PROPERTY);
        fieldDescriptionMapping.setGetMethodName("getFieldDescriptionForTopLink");
        fieldDescriptionMapping.setSetMethodName("setFieldDescriptionForTopLink");
        fieldDescriptionMapping.setXPath("field-description/text()");
        descriptor.addMapping((DatabaseMapping)fieldDescriptionMapping);
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        XMLCompositeCollectionMapping mappingHandlesMapping = new XMLCompositeCollectionMapping();
        mappingHandlesMapping.setAttributeName("mappingHandles");
        mappingHandlesMapping.setGetMethodName("getMappingHandlesForTopLink");
        mappingHandlesMapping.setSetMethodName("setMappingHandlesForTopLink");
        mappingHandlesMapping.setReferenceClass(MWMappingHandle.class);
        mappingHandlesMapping.setXPath("mapping-handles/mapping-handle");
        descriptor.addMapping((DatabaseMapping)mappingHandlesMapping);
        return descriptor;
    }

    private String getFieldDescriptionForTopLink() {
        return this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime();
    }

    private void setFieldDescriptionForTopLink(String fieldDescription) {
        this.fieldDescription = fieldDescription;
    }

    private List getMappingHandlesForTopLink() {
        return this.mappingHandles;
    }

    private void setMappingHandlesForTopLink(List handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWMappingHandle)stream.next()).setScrubber(MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        }
        this.mappingHandles = handles;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle columnHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = columnHandle == null ? new MWColumnHandle(this, scrubber) : columnHandle.setScrubber(scrubber);
    }

    @Override
    public void postProjectBuild() {
        Iterator aggregateFieldNameGenerators;
        super.postProjectBuild();
        if (this.fieldDescription == null) {
            return;
        }
        if (this.mappingHandles.size() == 0) {
            aggregateFieldNameGenerators = ((MWRelationalDescriptor)((Object)this.getAggregateMapping().getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
        } else {
            MWMappingHandle mappingHandle = (MWMappingHandle)this.mappingHandles.get(this.mappingHandles.size() - 1);
            aggregateFieldNameGenerators = mappingHandle.getMapping().aggregateFieldNameGenerators();
            if (!aggregateFieldNameGenerators.hasNext()) {
                aggregateFieldNameGenerators = ((MWRelationalDescriptor)((Object)((MWAggregateMapping)mappingHandle.getMapping()).getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
            }
        }
        while (aggregateFieldNameGenerators.hasNext()) {
            AggregateRuntimeFieldNameGenerator aggregateFieldNameGenerator = (AggregateRuntimeFieldNameGenerator)aggregateFieldNameGenerators.next();
            if (!this.fieldDescription.equals(aggregateFieldNameGenerator.fieldNameForRuntime())) continue;
            this.setAggregateRuntimeFieldNameGenerator(aggregateFieldNameGenerator);
            break;
        }
        this.fieldDescription = null;
    }
}

