/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public abstract class Member {
    private Pool pool;
    private short accessFlags;
    private short standardAccessFlags;
    private short nameIndex;
    private short descriptorIndex;
    private AttributePool attributePool;
    public static final short ACC_SYNTHETIC = 4096;

    Member(ClassFileDataInputStream stream, Pool pool) throws IOException {
        this.pool = pool;
        this.initialize(stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.accessFlags = stream.readU2();
        this.standardAccessFlags = this.buildStandardAccessFlags();
        this.nameIndex = stream.readU2();
        this.descriptorIndex = stream.readU2();
        this.attributePool = new AttributePool(stream, this.classFile());
    }

    private short buildStandardAccessFlags() {
        short result = this.accessFlags;
        result = (short)(result & this.visibleAccessFlagsMask());
        return result;
    }

    abstract short visibleAccessFlagsMask();

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        this.printDeclarationOn(writer);
        writer.println();
        writer.indent();
        this.attributePool.displayStringOn(writer);
        writer.undent();
    }

    public abstract void printDeclarationOn(PrintWriter var1);

    void printModifierOn(PrintWriter writer) {
        String modifierString = this.modifierString();
        if (modifierString.length() != 0) {
            writer.print(modifierString);
            writer.print(' ');
        }
    }

    public void accept(Visitor visitor) {
        this.attributePool.accept(visitor);
    }

    public String modifierString() {
        return Modifier.toString(this.standardAccessFlags);
    }

    public String name() {
        return this.constantPool().getUTF8String(this.nameIndex);
    }

    public String descriptor() {
        return this.constantPool().getUTF8String(this.descriptorIndex);
    }

    public boolean isDeprecated() {
        return this.attributePool.isDeprecated();
    }

    public boolean isSynthetic() {
        return this.isMarkedSyntheticByAccessFlag() || this.isMarkedSyntheticByAttribute();
    }

    public boolean isMarkedSyntheticByAccessFlag() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isMarkedSyntheticByAttribute() {
        return this.attributePool.isSynthetic();
    }

    public Pool getPool() {
        return this.pool;
    }

    public ClassFile classFile() {
        return this.pool.getClassFile();
    }

    public String declaringClassName() {
        return this.classFile().className();
    }

    public ConstantPool constantPool() {
        return this.classFile().getConstantPool();
    }

    public short standardAccessFlags() {
        return this.standardAccessFlags;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    public final String toString() {
        StringWriter sw = new StringWriter(200);
        PrintWriter pw = new PrintWriter(sw);
        pw.print(ClassTools.shortClassNameForObject(this));
        pw.print('(');
        this.printDeclarationOn(pw);
        pw.print(')');
        return sw.toString();
    }

    public static interface Pool {
        public ClassFile getClassFile();
    }
}

