/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resolver {
    private boolean nullAllowed;
    private final Resolver parent;
    private Map<String, Resolver> resolvers;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    protected Resolver(Resolver parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    public final void addChild(String variableName, Resolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new HashMap<String, Resolver>();
        }
        this.resolvers.put(variableName, resolver);
    }

    protected IType buildType() {
        return this.getTypeDeclaration().getType();
    }

    protected abstract ITypeDeclaration buildTypeDeclaration();

    protected void checkParent(Resolver parent) {
        if (parent == null) {
            throw new NullPointerException("The parent resolver cannot be null");
        }
    }

    public final Resolver getChild(String variableName) {
        return this.resolvers != null ? this.resolvers.get(variableName) : null;
    }

    public IManagedType getManagedType() {
        return null;
    }

    public IMapping getMapping() {
        return null;
    }

    public Resolver getParent() {
        return this.parent;
    }

    public final IManagedType getParentManagedType() {
        return this.parent.getManagedType();
    }

    public final IMapping getParentMapping() {
        return this.parent.getMapping();
    }

    public final IType getParentType() {
        return this.parent.getType();
    }

    public final ITypeDeclaration getParentTypeDeclaration() {
        return this.parent.getTypeDeclaration();
    }

    public final IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    public IQuery getQuery() {
        return this.parent.getQuery();
    }

    public final IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    public final IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    public final IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    public final ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public final TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public final ITypeRepository getTypeRepository() {
        return this.getQuery().getProvider().getTypeRepository();
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }
}

