/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapValue;
import org.eclipse.persistence.testing.models.collections.map.EntityAggregateMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;
import org.eclipse.persistence.testing.tests.collections.map.TestReadEntityAggregateMapMapping;

public class TestUpdateEntityAggregateMapMapping
extends TestReadEntityAggregateMapMapping {
    private boolean usePrivateOwned = false;
    protected ForeignReferenceMapping keyMapping = null;
    private boolean oldKeyPrivateOwnedValue = false;
    protected EntityAggregateMapHolder changedHolder = null;

    public TestUpdateEntityAggregateMapMapping() {
    }

    public TestUpdateEntityAggregateMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateEntityAggregateMapMapping privateOwned=" + usePrivateOwned);
    }

    @Override
    public void setup() {
        AggregateCollectionMapping mapping = (AggregateCollectionMapping)this.getSession().getProject().getDescriptor(EntityAggregateMapHolder.class).getMappingForAttributeName("entityToAggregateMap");
        this.keyMapping = (ForeignReferenceMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping();
        this.oldKeyPrivateOwnedValue = this.keyMapping.isPrivateOwned();
        this.keyMapping.setIsPrivateOwned(this.usePrivateOwned);
        super.setup();
    }

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(EntityAggregateMapHolder.class, this.holderExp);
        this.changedHolder = (EntityAggregateMapHolder)this.holders.get(0);
        EntityMapKey key = new EntityMapKey();
        key.setId(1);
        this.changedHolder.removeEntityToAggregateMapItem(key);
        AggregateMapValue mapValue = new AggregateMapValue();
        mapValue.setValue(3);
        key = new EntityMapKey();
        key.setId(3);
        key = (EntityMapKey)uow.registerObject((Object)key);
        this.changedHolder.addEntityToAggregateMapItem(key, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.holders = this.getSession().readAllObjects(EntityAggregateMapHolder.class, this.holderExp);
        EntityAggregateMapHolder holder = (EntityAggregateMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        EntityMapKey key = new EntityMapKey();
        key.setId(1);
        if (holder.getEntityToAggregateMap().containsKey(key)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        key = new EntityMapKey();
        key.setId(3);
        AggregateMapValue value = (AggregateMapValue)holder.getEntityToAggregateMap().get(key);
        if (value.getValue() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
        if (this.keyMapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapKey.class);
            ExpressionBuilder keys = new ExpressionBuilder();
            Expression keycriteria = keys.get("id").equal(1);
            query.setSelectionCriteria(keycriteria);
            key = (EntityMapKey)this.getSession().executeQuery((DatabaseQuery)query);
            if (key != null) {
                throw new TestErrorException("PrivateOwned EntityMapKey was not deleted.");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.keyMapping.setIsPrivateOwned(this.oldKeyPrivateOwnedValue);
    }
}

