/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class SequencingConcurrencyTest
extends TestCase
implements Comparator {
    public Vector sequences;
    public SequencingConcurrencyTest[] tests;
    public int nThreads;
    public boolean useServerSession;
    public boolean useSeparateConnection;
    public Server serverSession;
    public DatabaseSession dbSession;
    public int previousSequencePreallocationSize;
    public int sequencePreallocationSize;
    public boolean useSeparateConnectionOriginal;
    public boolean shouldLogMessages;
    public int originalLogLevel;
    public int nIterations;
    public Session session;
    public int threadNumber;
    public boolean handleException;
    public Exception exception;

    protected SequencingConcurrencyTest(int threadNumber, int nIterations, Vector sequences, Session session, boolean handleException) {
        this.threadNumber = threadNumber;
        this.nIterations = nIterations;
        this.sequences = sequences;
        this.session = session;
        this.handleException = handleException;
    }

    public SequencingConcurrencyTest(int nThreads, int nIterations, boolean useServerSession, boolean useSeparateConnection) {
        this(nThreads, nIterations, useServerSession, useSeparateConnection, 1);
    }

    public SequencingConcurrencyTest(int nThreads, int nIterations, boolean useServerSession, boolean useSeparateConnection, int sequencePreallocationSize) {
        this.nThreads = nThreads;
        this.nIterations = nIterations;
        this.useServerSession = useServerSession;
        this.useSeparateConnection = useSeparateConnection;
        String sessionUsed = useServerSession ? "ServerSession" : "DatabaseSession";
        this.shouldLogMessages = false;
        this.sequencePreallocationSize = sequencePreallocationSize;
        this.setName(this.getName() + " " + sessionUsed + " separateConnection=" + useSeparateConnection + " seqPreallocSize=" + sequencePreallocationSize + " threads=" + nThreads + " iterations=" + nIterations);
    }

    public int compare(Object b1, Object b2) {
        BigDecimal big1 = new BigDecimal(((Number)b1).longValue());
        BigDecimal big2 = new BigDecimal(((Number)b2).longValue());
        return big1.compareTo(big2);
    }

    public void reset() {
        if (this.useServerSession) {
            if (this.serverSession != null) {
                this.serverSession.logout();
                this.serverSession = null;
            }
        } else if (this.dbSession != null) {
            this.dbSession.getSequencingControl().initializePreallocated();
            if (this.useSeparateConnection != this.useSeparateConnectionOriginal) {
                this.dbSession.getSequencingControl().setShouldUseSeparateConnection(this.useSeparateConnectionOriginal);
                this.dbSession.getSequencingControl().resetSequencing();
            }
            this.dbSession.setLogLevel(this.originalLogLevel);
            this.dbSession = null;
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Number[] sequence = (Number[])SequencingConcurrencyTest.this.sequences.elementAt(SequencingConcurrencyTest.this.threadNumber);
                try {
                    if (SequencingConcurrencyTest.this.handleException) {
                        for (int i = 0; i < SequencingConcurrencyTest.this.nIterations; ++i) {
                            try {
                                sequence[i] = (Number)((AbstractSession)SequencingConcurrencyTest.this.session).getSequencing().getNextValue(Employee.class);
                                continue;
                            }
                            catch (ConcurrencyException ex) {
                                if (ex.getErrorCode() == 2006) {
                                    --i;
                                    continue;
                                }
                                throw ex;
                            }
                        }
                    } else {
                        for (int i = 0; i < SequencingConcurrencyTest.this.nIterations; ++i) {
                            sequence[i] = (Number)((AbstractSession)SequencingConcurrencyTest.this.session).getSequencing().getNextValue(Employee.class);
                        }
                    }
                }
                catch (Exception ex2) {
                    SequencingConcurrencyTest.this.exception = ex2;
                }
                finally {
                    if (SequencingConcurrencyTest.this.session.isClientSession()) {
                        SequencingConcurrencyTest.this.session.release();
                    }
                }
            }
        };
    }

    public void setup() {
        if (this.getAbstractSession().getDescriptor(Employee.class).getSequence().shouldAcquireValueAfterInsert()) {
            throw new TestWarningException("Not a valid test against databases where the native sequencing is done entirely in the database.");
        }
        this.dbSession = (DatabaseSession)this.getSession();
        if (this.useServerSession) {
            int numConnections = Math.min(this.nThreads, 5);
            this.serverSession = new Project(this.getSession().getDatasourceLogin().clone()).createServerSession(numConnections, numConnections);
            this.serverSession.addDescriptors((Project)new EmployeeProject());
            this.serverSession.getSequencingControl().setShouldUseSeparateConnection(this.useSeparateConnection);
            this.serverSession.setSessionLog(this.getSession().getSessionLog());
            if (this.shouldLogMessages) {
                this.serverSession.setLogLevel(3);
            }
            this.serverSession.login();
        } else {
            this.originalLogLevel = this.dbSession.getLogLevel();
            if (this.shouldLogMessages) {
                this.dbSession.setLogLevel(3);
            }
            this.dbSession.getSequencingControl().resetSequencing();
            this.dbSession.getSequencingControl().initializePreallocated();
            this.useSeparateConnectionOriginal = this.dbSession.getSequencingControl().shouldUseSeparateConnection();
            if (this.useSeparateConnection != this.useSeparateConnectionOriginal) {
                this.dbSession.getSequencingControl().setShouldUseSeparateConnection(this.useSeparateConnection);
                this.dbSession.getSequencingControl().resetSequencing();
            }
        }
        this.sequences = new Vector(this.nThreads);
        for (int i = 0; i < this.nThreads; ++i) {
            this.sequences.addElement(new Number[this.nIterations]);
        }
    }

    public void test() {
        int i;
        Thread[] threads = new Thread[this.nThreads];
        this.tests = new SequencingConcurrencyTest[this.nThreads];
        Session writeSession = this.getSession();
        boolean handleException = !this.useServerSession && !this.useSeparateConnection;
        for (i = 0; i < this.nThreads; ++i) {
            if (this.useServerSession) {
                writeSession = this.serverSession.acquireClientSession();
            }
            this.tests[i] = new SequencingConcurrencyTest(i, this.nIterations, this.sequences, writeSession, handleException);
            threads[i] = new Thread(this.tests[i].runnable());
            threads[i].start();
        }
        for (i = 0; i < this.nThreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (Exception ex) {
                throw new TestErrorException(ex.getMessage());
            }
        }
    }

    public void verify() {
        for (int i = 0; i < this.nThreads; ++i) {
            if (this.tests[i].exception == null) continue;
            throw new TestErrorException("exception in thread " + i + ", session(" + String.valueOf(System.identityHashCode(this.session)) + ") ", (Throwable)this.tests[i].exception);
        }
        Number[] big = new Number[this.nThreads * this.nIterations];
        for (int i = 0; i < this.nThreads; ++i) {
            System.arraycopy(this.sequences.elementAt(i), 0, big, i * this.nIterations, this.nIterations);
        }
        try {
            Arrays.sort(big, this);
            Number previous = big[0];
            for (int i = 1; i < this.nIterations * this.nThreads; ++i) {
                Number current = big[i];
                if (previous.intValue() + 1 != current.intValue()) {
                    throw new TestErrorException("Gap in sequencing, or incorrect sequences generated.");
                }
                previous = current;
            }
        }
        catch (Exception ex) {
            throw new TestErrorException(ex.getMessage());
        }
    }
}

