/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class UnitOfWorkCreateObjectReadTimeTest
extends CacheExpiryTest {
    protected Employee employee = null;

    public UnitOfWorkCreateObjectReadTimeTest() {
        this.setDescription("Test that the read time for objects created on a UnitOfWork is correctly set.");
    }

    public void test() {
        this.employee = new Employee();
        this.employee.setFirstName("Charley");
        this.employee.setLastName("Dickens");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.employee);
        uow.commit();
    }

    public void verify() {
        if (((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee).getReadTime() == 0L) {
            throw new TestErrorException("Objects created on a UnitOfWork do not have read time set.");
        }
    }
}

