/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.sessionbroker.Server;

public class Client
extends Thread {
    protected Server server;
    protected SessionBroker cSessionBroker;
    protected Session session;
    protected Object originalObject;
    protected UnitOfWork unitOfWork;
    protected Object objectToBeWritten;
    protected Expression expression;

    public Client(Server server, String employeeLastName, Session session) {
        super(employeeLastName);
        this.server = server;
        this.session = session;
        this.cSessionBroker = server.sSessionBroker.acquireClientSessionBroker();
        this.expression = new ExpressionBuilder().get("lastName").equal((Object)employeeLastName);
    }

    protected void changeObject() {
        int num = (int)(Math.random() * 5.0) + 1;
        Employee e = (Employee)this.objectToBeWritten;
        if (num == 1) {
            e.setSalary(e.getSalary() * 2);
        }
        if (num == 2) {
            Address a = new Address();
            a.setCity("Ottawa city");
            e.setAddress(a);
        }
        if (num == 3) {
            PhoneNumber p = new PhoneNumber();
            p.setNumber("1234");
            p.setType("SHOE");
            e.addPhoneNumber(p);
        }
        if (num == 4) {
            SmallProject s = new SmallProject();
            s.setName("project for me");
            e.addProject(s);
        }
        if (num == 5) {
            e.setFirstName(e.getFirstName() + "1");
        }
    }

    public void release() {
        this.cSessionBroker.release();
    }

    @Override
    public void run() {
        try {
            this.originalObject = this.cSessionBroker.readObject(Employee.class, this.expression);
            this.unitOfWork = this.cSessionBroker.acquireUnitOfWork();
            this.unitOfWork.readAllObjects(Employee.class);
            this.objectToBeWritten = this.unitOfWork.registerObject(this.originalObject);
            this.changeObject();
            this.unitOfWork.commit();
        }
        catch (Exception exception) {
            this.server.errorOccured = true;
            exception.printStackTrace(System.out);
        }
    }
}

