/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class TransactionIsolationRefreshTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;
    String oldName;
    Address oldAddress;
    ReadObjectQuery refreshQuery;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.refreshQuery = new ReadObjectQuery(Employee.class);
        this.refreshQuery.refreshIdentityMapResult();
        this.refreshQuery.cascadeAllParts();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.unitOfWork.release();
            this.unitOfWork = null;
            this.refreshQuery = null;
        }
    }

    public void test() {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression criteria = builder.get("period").get("endDate").notNull();
        Employee employee = (Employee)this.getSession().readObject(Employee.class, criteria);
        Address dummyAddress = new Address();
        dummyAddress.setCity("El Paso");
        Employee dummyManager = new Employee();
        dummyManager.setFirstName("Bill");
        SmallProject dummyProject = new SmallProject();
        dummyProject.setName("survive");
        employee.setFirstName("budd");
        employee.setAddress(dummyAddress);
        employee.getProjects().clear();
        employee.getProjects().add(dummyProject);
        employee.getPeriod().setEndDate(null);
        employee.setManager(dummyManager);
        Employee clone = (Employee)this.unitOfWork.registerObject((Object)employee);
        this.unitOfWork.beginEarlyTransaction();
        this.refreshQuery.setSelectionObject((Object)clone);
        clone = (Employee)this.unitOfWork.executeQuery((DatabaseQuery)this.refreshQuery);
        this.strongAssert(employee.getFirstName() == "budd", "Should not have refreshed the original (direct to field)");
        this.strongAssert(employee.getAddress() == dummyAddress, "Should not have refreshed the original (private one to one)");
        this.strongAssert(employee.getProjects().elementAt(0) == dummyProject, "Should not have refreshed the originial (many to many)");
        this.strongAssert(employee.getPeriod().getEndDate() == null, "Should not have refreshed the originial (aggregate)");
        this.strongAssert(employee.getManager() == dummyManager, "Should not have refreshed the originial (one to one)");
        this.strongAssert(!clone.getFirstName().equals("budd"), "Did not refresh the clone (direct to field)");
        this.strongAssert(!clone.getAddress().getCity().equals("El Paso"), "Did not refresh the clone (private one to one)");
        this.strongAssert(clone.getProjects().size() != 1 || !(clone.getProjects().elementAt(0) instanceof SmallProject) || !((SmallProject)clone.getProjects().elementAt(0)).getName().equals("survive"), "Did not refresh the clone (many to many)");
        this.strongAssert(clone.getPeriod().getEndDate() != null, "Did not refresh the clone (aggregate)");
        this.strongAssert(clone.getManager() == null || !clone.getManager().getFirstName().equals("Bill"), "Did not refresh the clone (one to one)");
    }
}

