/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.CollectionTable;
import org.eclipse.persistence.tools.mapping.orm.dom.Converter;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;

final class BasicMapMapping
extends ConvertibleMapping
implements ExternalBasicMapMapping {
    static final String BASIC_MAP = "basic-map";
    static final String FETCH = "fetch";
    static final String JOIN_FETCH = "join-fetch";
    static final String KEY_COLUMN = "key-column";
    static final String KEY_CONVERTER = "key-converter";
    static final String VALUE_COLUMN = "value-column";
    static final String VALUE_CONVERTER = "value-converter";

    BasicMapMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public final void addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
    }

    @Override
    public void addCollectionTable(String name) {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.addSelf();
        collectionTable.setName(name);
    }

    @Override
    public void addKeyColumn(String columnName) {
        EntityColumn column = this.buildColumn(KEY_COLUMN);
        column.addSelf();
        column.setName(columnName);
    }

    @Override
    public void addKeyConverterString(String converter) {
        this.updateChildTextNode(KEY_CONVERTER, converter);
    }

    @Override
    public void addValueColumn(String columnName) {
        EntityColumn column = this.buildColumn(VALUE_COLUMN);
        column.addSelf();
        column.setName(columnName);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(FETCH);
        names.add("access");
        return names;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private CollectionTable buildCollectionTable() {
        return new CollectionTable(this);
    }

    private EntityColumn buildColumn(String elementName) {
        return new EntityColumn(this, elementName);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(KEY_COLUMN);
        names.add(KEY_CONVERTER);
        names.add(VALUE_COLUMN);
        names.add(VALUE_CONVERTER);
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("collection-table");
        names.add(JOIN_FETCH);
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private Converter buildKeyConverter() {
        return new Converter(this);
    }

    private ObjectTypeConverter buildKeyObjectTypeConverter() {
        return new ObjectTypeConverter(this);
    }

    private StructConverter buildKeyStructConverter() {
        return new StructConverter(this);
    }

    private TypeConverter buildKeyTypeConverter() {
        return new TypeConverter(this);
    }

    @Override
    public final ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public ExternalCollectionTable getCollectionTable() {
        if (this.hasChild("collection-table")) {
            return this.buildCollectionTable();
        }
        return null;
    }

    @Override
    public String getConvert() {
        return this.getChildTextNode(VALUE_CONVERTER);
    }

    @Override
    protected String getElementName() {
        return BASIC_MAP;
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode(JOIN_FETCH, JoinFetchType.class);
    }

    @Override
    public ExternalEntityColumn getKeyColumn() {
        if (this.hasChild(KEY_COLUMN)) {
            return this.buildColumn(KEY_COLUMN);
        }
        return null;
    }

    @Override
    public ExternalConverter getKeyConverter() {
        if (this.hasChild("converter")) {
            return this.buildKeyConverter();
        }
        return null;
    }

    @Override
    public String getKeyConveter() {
        return this.getChildTextNode(KEY_CONVERTER);
    }

    @Override
    public ExternalObjectTypeConverter getKeyObjectTypeConverter() {
        if (this.hasChild("object-type-converter")) {
            return this.buildKeyObjectTypeConverter();
        }
        return null;
    }

    @Override
    public ExternalStructConverter getKeyStructConverter() {
        if (this.hasChild(KEY_CONVERTER)) {
            return this.buildKeyStructConverter();
        }
        return null;
    }

    @Override
    public ExternalTypeConverter getKeyTypeConverter() {
        if (this.hasChild("type-converter")) {
            return this.buildKeyTypeConverter();
        }
        return null;
    }

    @Override
    public ExternalEntityColumn getValueColumn() {
        if (this.hasChild(VALUE_COLUMN)) {
            return this.buildColumn(VALUE_COLUMN);
        }
        return null;
    }

    @Override
    public final void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public void removeCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.removeSelf();
    }

    @Override
    public void removeKeyColumn() {
        EntityColumn column = this.buildColumn(KEY_COLUMN);
        column.removeSelf();
    }

    @Override
    public final void removeKeyConverter() {
        this.removeChild("converter");
    }

    @Override
    public void removeKeyConverterString() {
        EntityColumn column = this.buildColumn(KEY_CONVERTER);
        column.removeSelf();
    }

    @Override
    public final void removeKeyObjectTypeConverter() {
        this.removeChild("object-type-converter");
    }

    @Override
    public final void removeKeyStructConverter() {
        this.removeChild("struct-converter");
    }

    @Override
    public final void removeKeyTypeConverter() {
        this.removeChild("type-converter");
    }

    @Override
    public void removeValueColumn() {
        EntityColumn column = this.buildColumn(VALUE_COLUMN);
        column.removeSelf();
    }

    @Override
    public void setAsKeyConverter(String name, String className) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        Converter valueConverter = this.buildKeyConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setConverterClassName(className);
    }

    @Override
    public void setAsKeyObjectTypeConverter(String name) {
        this.removeChild("type-converter");
        this.removeChild("converter");
        this.removeChild("struct-converter");
        ObjectTypeConverter valueConverter = this.buildKeyObjectTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setAsKeyStructConverter(String name, String converter) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("converter");
        StructConverter valueConverter = this.buildKeyStructConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setConverterClassName(converter);
    }

    @Override
    public void setAsKeyTypeConverter(String name) {
        this.removeChild("converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        TypeConverter valueConverter = this.buildKeyTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setConvert(String value) {
        this.updateChildTextNode(VALUE_CONVERTER, value);
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute(FETCH, (Enum<?>)type);
    }

    @Override
    public void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode(JOIN_FETCH, (Enum<?>)type);
    }

    @Override
    public void setKeyConverter(String value) {
        this.updateChildTextNode(KEY_CONVERTER, value);
    }
}

