/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.tools.mapping.orm.ExternalCache;
import org.eclipse.persistence.tools.mapping.orm.ExternalTimeOfDay;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.TimeOfDay;

final class Cache
extends AbstractExternalForm
implements ExternalCache {
    static final String ALWAYS_REFRESH = "always-refresh";
    static final String CACHE = "cache";
    static final String COORDINATION_TYPE = "coordination-type";
    static final String DATABASE_CHANGE_NOTIFICATION_TYPE = "database-change-notification-type";
    static final String DISABLE_HITS = "disable-hits";
    static final String EXPIRY = "expiry";
    static final String ISOLATION = "isolation";
    static final String REFRESH_ONLY_IF_NEWER = "refresh-only-if-newer";
    static final String SHARED = "shared";
    static final String SIZE = "size";
    static final String TYPE = "type";

    Cache(MappedSuperClassEntity parent) {
        super(parent);
    }

    @Override
    public void addExpiryTimeOfDay() {
        TimeOfDay timeOfDay = this.buildTimeOfDay();
        timeOfDay.addSelf();
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(SIZE);
        names.add(SHARED);
        names.add(TYPE);
        names.add(ALWAYS_REFRESH);
        names.add(REFRESH_ONLY_IF_NEWER);
        names.add(DISABLE_HITS);
        names.add(COORDINATION_TYPE);
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(EXPIRY);
        names.add("expiry-time-of-day");
        return names;
    }

    private TimeOfDay buildTimeOfDay() {
        return new TimeOfDay(this);
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.getEnumAttribute(COORDINATION_TYPE, CacheCoordinationType.class);
    }

    @Override
    public DatabaseChangeNotificationType getDatabaseChangeNotificationType() {
        return this.getEnumAttribute(DATABASE_CHANGE_NOTIFICATION_TYPE, DatabaseChangeNotificationType.class);
    }

    @Override
    protected String getElementName() {
        return CACHE;
    }

    @Override
    public ExternalTimeOfDay getExpiryTimeOfDay() {
        if (this.hasChild("expiry-time-of-day")) {
            return this.buildTimeOfDay();
        }
        return null;
    }

    @Override
    public Integer getExpiryTimeToLive() {
        return this.getChildIntegerNode(EXPIRY);
    }

    @Override
    public CacheIsolationType getIsolationType() {
        return this.getEnumAttribute(ISOLATION, CacheIsolationType.class);
    }

    @Override
    public Integer getSize() {
        return this.getIntegerAttribute(SIZE);
    }

    @Override
    public CacheType getType() {
        return this.getEnumAttribute(TYPE, CacheType.class);
    }

    @Override
    public Boolean isAlwaysRefresh() {
        return this.getBooleanAttribute(ALWAYS_REFRESH);
    }

    @Override
    public Boolean isDisableHits() {
        return this.getBooleanAttribute(DISABLE_HITS);
    }

    @Override
    public Boolean isRefreshOnlyIfNewer() {
        return this.getBooleanAttribute(REFRESH_ONLY_IF_NEWER);
    }

    @Override
    public Boolean isShared() {
        return this.getBooleanAttribute(SHARED);
    }

    @Override
    public void removeExpiryTimeOfDay() {
        TimeOfDay timeOfDay = this.buildTimeOfDay();
        timeOfDay.removeSelf();
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.setAttribute(ALWAYS_REFRESH, alwaysRefresh);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setCoordinationType(CacheCoordinationType type) {
        this.setAttribute(COORDINATION_TYPE, (Enum<?>)type);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setDatabaseChangeNotificationType(DatabaseChangeNotificationType type) {
        this.setAttribute(DATABASE_CHANGE_NOTIFICATION_TYPE, (Enum<?>)type);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setDisableHits(Boolean disableHits) {
        this.setAttribute(DISABLE_HITS, disableHits);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setExpiryTimeToLive(Integer timeToLive) {
        this.updateChildTextNode(EXPIRY, timeToLive);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setIsolationType(CacheIsolationType isolationType) {
        this.setAttribute(ISOLATION, (Enum<?>)isolationType);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.setAttribute(REFRESH_ONLY_IF_NEWER, refreshOnlyIfNewer);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setShared(Boolean shared) {
        this.setAttribute(SHARED, shared);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setSize(Integer size) {
        this.setAttribute(SIZE, size);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setType(CacheType type) {
        this.setAttribute(TYPE, (Enum<?>)type);
        if (!this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }
}

