/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalElementCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalOrderColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.AssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.CollectionTable;
import org.eclipse.persistence.tools.mapping.orm.dom.Converter;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EmbeddableEntity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.OrderColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.ClassNameTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class ElementCollectionMapping
extends ConvertibleMapping
implements ExternalElementCollectionMapping {
    static String CLASS = "class";
    static String CONVERT_KEY = "convert-key";
    static String ELEMENT_COLLECTION = "element-collection";
    static String ENUMERATED = "enumerated";
    static String FETCH = "fetch";
    static String JOIN_FETCH = "join-fetch";
    static String LOB = "lob";
    static String MAP_KEY = "map-key";
    static String MAP_KEY_ASSOCIATION_OVERRIDE = "map-key-association-override";
    static String MAP_KEY_ATTRIBUTE_OVERRIDE = "map-key-attribute-override";
    static String MAP_KEY_CLASS = "map-key-class";
    static String MAP_KEY_COLUMN = "map-key-column";
    static String MAP_KEY_CONVERT = "map-key-convert";
    static String MAP_KEY_ENUMERATED = "map-key-enumerated";
    static String MAP_KEY_JOIN_COLUMN = "map-key-join-column";
    static String MAP_KEY_TEMPORAL = "map-key-temporal";
    static String ORDER_BY = "order-by";
    static String TARGET_CLASS = "target-class";
    static String TEMPORAL = "temporal";

    ElementCollectionMapping(EmbeddableEntity parent, int index) {
        super(parent, index);
    }

    @Override
    public void addAssociationOverride(int index, String name) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.addSelf();
        associationOverride.setName(name);
    }

    @Override
    public void addAttributeOverride(int index, String name) {
        AttributeOverride attributeOverride = this.buildAttributeOverride(index);
        attributeOverride.addSelf();
        attributeOverride.setName(name);
    }

    @Override
    public void addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
    }

    @Override
    public ExternalCollectionTable addCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.addSelf();
        return collectionTable;
    }

    @Override
    public ExternalAssociationOverride addMapKeyAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildMapKeyAssociationOverride(this.mapKeyAssociationOverridesSize());
        associationOverride.addSelf();
        return associationOverride;
    }

    @Override
    public ExternalAttributeOverride addMapKeyAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(this.mapKeyAttributeOverridesSize());
        attributeOverride.addSelf();
        return attributeOverride;
    }

    @Override
    public void addMapKeyColumn() {
        EntityColumn column = this.buildColumn(MAP_KEY_COLUMN);
        column.addSelf();
    }

    @Override
    public void addMapKeyJoinColumn(int index, String name) {
        JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
        joinColumn.addSelf();
        joinColumn.setName(name);
    }

    @Override
    public void addOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.addSelf();
    }

    private AssociationOverride buildAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add(TARGET_CLASS);
        names.add(FETCH);
        names.add("access");
        names.add("attribute-type");
        return names;
    }

    private AttributeOverride buildAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private CollectionTable buildCollectionTable() {
        return new CollectionTable(this);
    }

    private EntityColumn buildColumn(String elementName) {
        return new EntityColumn(this, elementName);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("field");
        names.add("attribute-override");
        names.add("association-override");
        names.add(ORDER_BY);
        names.add("order-column");
        names.add(MAP_KEY);
        names.add(MAP_KEY_CLASS);
        names.add(MAP_KEY_TEMPORAL);
        names.add(MAP_KEY_ENUMERATED);
        names.add(MAP_KEY_CONVERT);
        names.add(MAP_KEY_ATTRIBUTE_OVERRIDE);
        names.add(MAP_KEY_ASSOCIATION_OVERRIDE);
        names.add(MAP_KEY_COLUMN);
        names.add(MAP_KEY_JOIN_COLUMN);
        names.add("collection-table");
        names.add("batch-fetch");
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private JoinColumn buildJoinColumn(String elementName, int index) {
        return new JoinColumn(this, elementName, index);
    }

    private Converter buildKeyConverter() {
        return new Converter(this);
    }

    private ObjectTypeConverter buildKeyObjectTypeConverter() {
        return new ObjectTypeConverter(this);
    }

    private StructConverter buildKeyStructConverter() {
        return new StructConverter(this);
    }

    private TypeConverter buildKeyTypeConverter() {
        return new TypeConverter(this);
    }

    private AssociationOverride buildMapKeyAssociationOverride(int index) {
        return new AssociationOverride(this, index);
    }

    private AttributeOverride buildMapKeyAttributeOverride(int index) {
        return new AttributeOverride(this, index);
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    private OrderColumn buildOrderColumn() {
        return new OrderColumn(this);
    }

    @Override
    public ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public ExternalCollectionTable getCollectionTable() {
        if (this.hasChild("collection-table")) {
            return this.buildCollectionTable();
        }
        return null;
    }

    @Override
    public ExternalEntityColumn getColumn() {
        if (this.hasChild("column")) {
            return this.buildColumn("column");
        }
        return null;
    }

    @Override
    public String getConvertKey() {
        return this.getChildTextNode(CONVERT_KEY);
    }

    @Override
    protected String getElementName() {
        return ELEMENT_COLLECTION;
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getChildEnumNode(ENUMERATED, EnumType.class);
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute(FETCH, FetchType.class);
    }

    @Override
    public JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode(JOIN_FETCH, JoinFetchType.class);
    }

    @Override
    public ExternalConverter getKeyConverter() {
        if (this.hasChild("converter")) {
            return this.buildKeyConverter();
        }
        return null;
    }

    @Override
    public ExternalObjectTypeConverter getKeyObjectTypeConverter() {
        if (this.hasChild("object-type-converter")) {
            return this.buildKeyObjectTypeConverter();
        }
        return null;
    }

    @Override
    public ExternalStructConverter getKeyStructConverter() {
        if (this.hasChild("struct-converter")) {
            return this.buildKeyStructConverter();
        }
        return null;
    }

    @Override
    public ExternalTypeConverter getKeyTypeConverter() {
        if (this.hasChild("type-converter")) {
            return this.buildKeyTypeConverter();
        }
        return null;
    }

    @Override
    public String getMapKey() {
        Element element = this.getChild(MAP_KEY);
        if (element == null) {
            return null;
        }
        return this.getAttribute(element, "name");
    }

    @Override
    public ExternalAssociationOverride getMapKeyAssociationOverride(int index) {
        Element element = this.getChild("association-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAssociationOverride(index);
    }

    @Override
    public ExternalAttributeOverride getMapKeyAttributeOverride(int index) {
        Element element = this.getChild("attribute-override", index);
        if (element == null) {
            return null;
        }
        return this.buildAttributeOverride(index);
    }

    @Override
    public String getMapKeyClassName() {
        Element element = this.getChild(MAP_KEY_CLASS);
        if (element == null) {
            return null;
        }
        return this.getAttribute(element, CLASS);
    }

    @Override
    public ExternalEntityColumn getMapKeyColumn() {
        if (this.hasChild(MAP_KEY_COLUMN)) {
            return this.buildColumn(MAP_KEY_COLUMN);
        }
        return null;
    }

    @Override
    public String getMapKeyConverterName() {
        return this.getChildTextNode(MAP_KEY_CONVERT);
    }

    @Override
    public EnumType getMapKeyEnumeratedType() {
        return this.getChildEnumNode(MAP_KEY_ENUMERATED, EnumType.class);
    }

    @Override
    public ExternalJoinColumn getMapKeyJoinColumn(int index) {
        Element element = this.getChild(MAP_KEY_JOIN_COLUMN, index);
        if (element == null) {
            return null;
        }
        return this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
    }

    @Override
    public TemporalType getMapKeyTemporalType() {
        return this.getChildEnumNode(MAP_KEY_TEMPORAL, TemporalType.class);
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public String getOrderByFieldName() {
        return this.getChildTextNode(ORDER_BY);
    }

    @Override
    public ExternalOrderColumn getOrderColumn() {
        if (this.hasChild("order-column")) {
            return this.buildOrderColumn();
        }
        return null;
    }

    @Override
    public String getTargetClassName() {
        return this.getAttribute(TARGET_CLASS);
    }

    @Override
    public String getTargetClassShortName() {
        return ClassNameTools.simpleName((String)this.getTargetClassName());
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode(TEMPORAL, TemporalType.class);
    }

    @Override
    public boolean isElementCollectionMapping() {
        return true;
    }

    @Override
    public Boolean isLob() {
        return this.getChildBooleanNode(LOB);
    }

    @Override
    public ListIterable<ExternalAssociationOverride> mapKeyAssociationOverrides() {
        int count = this.mapKeyAssociationOverridesSize();
        ArrayList<AssociationOverride> associationOverrides = new ArrayList<AssociationOverride>(count);
        int index = count;
        while (--index >= 0) {
            AssociationOverride associationOverride = this.buildAssociationOverride(index);
            associationOverrides.add(0, associationOverride);
        }
        return new ListListIterable(associationOverrides);
    }

    @Override
    public int mapKeyAssociationOverridesSize() {
        return this.getChildrenSize("association-override");
    }

    @Override
    public ListIterable<ExternalAttributeOverride> mapKeyAttributeOverrides() {
        int count = this.mapKeyAttributeOverridesSize();
        ArrayList<AttributeOverride> attributeOverrides = new ArrayList<AttributeOverride>(count);
        int index = count;
        while (--index >= 0) {
            AttributeOverride attributeOverride = this.buildAttributeOverride(index);
            attributeOverrides.add(0, attributeOverride);
        }
        return new ListListIterable(attributeOverrides);
    }

    @Override
    public int mapKeyAttributeOverridesSize() {
        return this.getChildrenSize("attribute-override");
    }

    @Override
    public ListIterable<ExternalJoinColumn> mapKeyJoinColumns() {
        int count = this.mapKeyJoinColumnsSize();
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>(count);
        int index = count;
        while (--index >= 0) {
            JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
            joinColumns.add(0, joinColumn);
        }
        return new ListListIterable(joinColumns);
    }

    @Override
    public int mapKeyJoinColumnsSize() {
        return this.getChildrenSize(MAP_KEY_JOIN_COLUMN);
    }

    @Override
    public void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public void removeCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.removeSelf();
    }

    @Override
    public void removeColumn() {
        EntityColumn column = this.buildColumn("column");
        column.removeSelf();
    }

    @Override
    public void removeKeyConverter() {
        this.removeChild("converter");
    }

    @Override
    public void removeKeyObjectTypeConverter() {
        this.removeChild("object-type-converter");
    }

    @Override
    public void removeKeyStructConverter() {
        this.removeChild("struct-converter");
    }

    @Override
    public void removeKeyTypeConverter() {
        this.removeChild("type-converter");
    }

    @Override
    public void removeMapKeyAssociationOverride(int index) {
        AssociationOverride associationOverride = this.buildAssociationOverride(index);
        associationOverride.removeSelf();
    }

    @Override
    public void removeMapKeyAttributeOverride(int index) {
        AttributeOverride attributeOverride = this.buildMapKeyAttributeOverride(index);
        attributeOverride.removeSelf();
    }

    @Override
    public void removeMapKeyColumn() {
        EntityColumn column = this.buildColumn(MAP_KEY_COLUMN);
        column.removeSelf();
    }

    @Override
    public void removeMapKeyJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(MAP_KEY_JOIN_COLUMN, index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeOrderColumn() {
        OrderColumn orderColumn = this.buildOrderColumn();
        orderColumn.removeSelf();
    }

    @Override
    public void setAsKeyConverter(String name, String className) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        Converter valueConverter = this.buildKeyConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setConverterClassName(className);
    }

    @Override
    public void setAsKeyObjectTypeConverter(String name) {
        this.removeChild("type-converter");
        this.removeChild("converter");
        this.removeChild("struct-converter");
        ObjectTypeConverter valueConverter = this.buildKeyObjectTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setAsKeyStructConverter(String name, String converter) {
        this.removeChild("type-converter");
        this.removeChild("object-type-converter");
        this.removeChild("converter");
        StructConverter valueConverter = this.buildKeyStructConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
        valueConverter.setConverterClassName(converter);
    }

    @Override
    public void setAsKeyTypeConverter(String name) {
        this.removeChild("converter");
        this.removeChild("object-type-converter");
        this.removeChild("struct-converter");
        TypeConverter valueConverter = this.buildKeyTypeConverter();
        valueConverter.addSelf();
        valueConverter.setName(name);
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setColumn(String columnName) {
        EntityColumn column = this.buildColumn("column");
        column.addSelf();
        column.setName(columnName);
    }

    @Override
    public void setConvertKey(String value) {
        this.updateChildTextNode(CONVERT_KEY, value);
    }

    @Override
    public void setEnumeratedType(EnumType type) {
        this.updateChildTextNode(ENUMERATED, (Enum<?>)type);
    }

    @Override
    public void setFetchType(FetchType fetchType) {
        this.setAttribute(FETCH, (Enum<?>)fetchType);
    }

    @Override
    public void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode(JOIN_FETCH, (Enum<?>)type);
    }

    @Override
    public void setLob(Boolean lob) {
        this.updateChildTextNode(LOB, lob);
    }

    @Override
    public void setMapKey(String mapKey) {
        if (mapKey == null) {
            this.removeChild(MAP_KEY);
        } else {
            Element element = this.getChild(MAP_KEY);
            if (element == null) {
                element = this.addChild(MAP_KEY);
            }
            this.setAttribute(element, "name", mapKey);
        }
    }

    @Override
    public void setMapKeyClassName(String className) {
        if (className == null) {
            this.removeChild(MAP_KEY_CLASS);
        } else {
            Element element = this.getChild(MAP_KEY_CLASS);
            if (element == null) {
                element = this.addChild(MAP_KEY_CLASS);
            }
            this.setAttribute(element, CLASS, className);
        }
    }

    @Override
    public void setMapKeyConverterName(String converterName) {
        this.updateChildTextNode(MAP_KEY_CONVERT, converterName);
    }

    @Override
    public void setMapKeyEnumeratedType(EnumType enumType) {
        this.updateChildTextNode(MAP_KEY_ENUMERATED, (Enum<?>)enumType);
    }

    @Override
    public void setMapKeyTemporalType(TemporalType temporalType) {
        this.updateChildTextNode(MAP_KEY_TEMPORAL, (Enum<?>)temporalType);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }

    @Override
    public void setOrderByFieldName(String orderBy) {
        this.updateChildTextNode(ORDER_BY, orderBy);
    }

    @Override
    public void setTargetClassName(String className) {
        this.setAttribute(TARGET_CLASS, className);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode(TEMPORAL, (Enum<?>)type);
    }
}

