/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;

public abstract class AbstractSimultaneousIterator<E, I extends Iterator<E>>
implements Iterator<List<E>> {
    protected final Iterable<? extends I> iterators;
    protected final int iteratorsSize;

    protected <T extends I> AbstractSimultaneousIterator(T ... iterators) {
        this((Iterable<T>)new ArrayIterable<T>(iterators), iterators.length);
    }

    protected <T extends I> AbstractSimultaneousIterator(Iterable<T> iterators) {
        this(iterators, -1);
    }

    protected <T extends I> AbstractSimultaneousIterator(Iterable<T> iterators, int iteratorsSize) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
        this.iteratorsSize = iteratorsSize;
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorsIsEmpty()) {
            return false;
        }
        for (Iterator iterator : this.iterators) {
            if (iterator.hasNext()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<E> next() {
        if (this.iteratorsIsEmpty()) {
            throw new NoSuchElementException();
        }
        ArrayList result = this.buildList();
        for (Iterator iterator : this.iterators) {
            result.add(iterator.next());
        }
        return result;
    }

    protected ArrayList<E> buildList() {
        return this.iteratorsSize < 0 ? new ArrayList() : new ArrayList(this.iteratorsSize);
    }

    @Override
    public void remove() {
        if (this.iteratorsIsEmpty()) {
            throw new IllegalStateException();
        }
        for (Iterator iterator : this.iterators) {
            iterator.remove();
        }
    }

    protected boolean iteratorsIsEmpty() {
        return IterableTools.isEmpty(this.iterators);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

