/*******************************************************************************
 * Copyright (c) 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.db;

import org.eclipse.persistence.tools.db.model.ELColumn;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.JavaType;
import org.eclipse.persistence.tools.utility.SimpleJavaType;

/**
 * The concrete implementation of {@link Column}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
@SuppressWarnings("nls")
public class EclipseLinkColumn implements Column {

	private ELColumn column;
	private EclipseLinkTable parent;

	public EclipseLinkColumn(EclipseLinkTable parent, ELColumn column) {
		this.parent = parent;
		this.column = column;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ConnectionProfile getConnectionProfile() {
		throw new UnsupportedOperationException("Not Supported!");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Database getDatabase() {
		return this.parent.getDatabase();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDataTypeName() {
		return this.column.getDatabaseType().getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getIdentifier() {
		return getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getIdentifier(String defaultName) {
		return getDatabase().convertNameToIdentifier(getName());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public JavaType getJavaType() {
		return new SimpleJavaType(getJavaTypeDeclaration());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getJavaTypeDeclaration() {
		return this.column.getDatabaseType().javaTypeDeclaration().getJavaClassName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getLength() {
		// TODO: JBB
		return 0;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return column.getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPrecision() {
		// TODO: JBB
		return 0;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public JavaType getPrimaryKeyJavaType() {
		// TODO: JBB
		return getJavaType();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPrimaryKeyJavaTypeDeclaration() {
		// TODO: JBB
		return getJavaTypeDeclaration();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getScale() {
		// TODO: JBB
		return 0;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Table getTable() {
		return this.parent;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isLOB() {
		// TODO: JBB
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isNullable() {
		return this.column.getDatabaseType().allowsNull();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isNumeric() {
		// TODO: JBB
		return false;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isPartOfForeignKey() {
		return this.column.isIdentity();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isPartOfPrimaryKey() {
		return this.column.isPrimaryKey();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isPartOfUniqueConstraint() {
		return column.isUnique();
	}
}