/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.AccessType;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * This interface represents the basis for all non-transient mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalNonTransientMapping extends ExternalMapping {

	/**
	 * Adds the get and set method names for this mapping.
	 */
	void addAccessMethods(String getMethodName, String setMethodName);

	/**
	 * Adds a property with the given name/value pair to the mapping.
	 */
	void addProperty(int index, String name, String value);

	/**
	 * Returns the access methods for this mapping.
	 */
	ExternalAccessMethods getAccessMethods();

	/**
	 * Returns the access type for this mapping.
	 */
	AccessType getAccessType();

	/**
	 * Returns the property at the given index.
	 */
	ExternalProperty getProperty(int index);

	/**
	 * Returns a list of the properties defined for this entity.
	 */
	ListIterable<ExternalProperty> properties();

	/**
	 * Returns the count of properties defined for this entity.
	 */
	int propertiesSize();

	/**
	 * Removes the access methods element from the mapping.
	 */
	void removeAccessMethods();

	/**
	 * Removes the property specified at the given position.
	 */
	void removeProperty(int index);

	/**
	 * Sets the access type for this mapping.
	 */
	void setAccessType(AccessType type);
}