/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.eclipse.persistence.jaxb.ReflectionUtils;
import org.eclipse.persistence.jaxb.ValidationXMLReader;

enum BeanValidationHelper {
    BEAN_VALIDATION_HELPER;

    private static final int TIMEOUT = 10;
    private static boolean xmlParsed;
    private final Set<Class<? extends Annotation>> knownConstraints = new HashSet<Class<? extends Annotation>>();
    private final Map<Class<?>, Boolean> constraintsOnClasses = new HashMap();

    static {
        ValidationXMLReader.runAsynchronously();
        xmlParsed = false;
    }

    private BeanValidationHelper() {
        this.knownConstraints.add(Valid.class);
        this.knownConstraints.add(Max.class);
        this.knownConstraints.add(Min.class);
        this.knownConstraints.add(DecimalMax.class);
        this.knownConstraints.add(DecimalMin.class);
        this.knownConstraints.add(Digits.class);
        this.knownConstraints.add(NotNull.class);
        this.knownConstraints.add(Pattern.class);
        this.knownConstraints.add(Size.class);
        this.knownConstraints.add(AssertTrue.class);
        this.knownConstraints.add(AssertFalse.class);
        this.knownConstraints.add(Future.class);
        this.knownConstraints.add(Past.class);
        this.knownConstraints.add(Max.List.class);
        this.knownConstraints.add(Min.List.class);
        this.knownConstraints.add(DecimalMax.List.class);
        this.knownConstraints.add(DecimalMin.List.class);
        this.knownConstraints.add(Digits.List.class);
        this.knownConstraints.add(NotNull.List.class);
        this.knownConstraints.add(Pattern.List.class);
        this.knownConstraints.add(Size.List.class);
        this.knownConstraints.add(AssertTrue.List.class);
        this.knownConstraints.add(AssertFalse.List.class);
        this.knownConstraints.add(Future.List.class);
        this.knownConstraints.add(Past.List.class);
    }

    Boolean putConstrainedClass(Class<?> clazz) {
        return this.constraintsOnClasses.put(clazz, Boolean.TRUE);
    }

    boolean isConstrained(Class<?> clazz) {
        Boolean annotated;
        if (!xmlParsed) {
            this.ensureValidationXmlWasParsed();
        }
        if ((annotated = this.constraintsOnClasses.get(clazz)) == null) {
            annotated = this.detectConstraints(clazz);
            this.constraintsOnClasses.put(clazz, annotated);
        }
        return annotated;
    }

    private Boolean detectConstraints(Class<?> clazz) {
        Class<? extends Annotation> classAnnotationType;
        Annotation typesClassAnnotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        Class<? extends Annotation> type;
        Annotation a;
        int n3;
        int n4;
        Annotation[] annotationArray2;
        AccessibleObject[] accessibleObjectArray = ReflectionUtils.getDeclaredFields(clazz);
        int n5 = accessibleObjectArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Field f = accessibleObjectArray[n6];
            annotationArray2 = f.getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type = a.annotationType();
                if (this.knownConstraints.contains(type)) {
                    return true;
                }
                annotationArray = type.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.knownConstraints.add(type);
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        accessibleObjectArray = ReflectionUtils.getDeclaredMethods(clazz);
        n5 = accessibleObjectArray.length;
        n6 = 0;
        while (n6 < n5) {
            AccessibleObject m = accessibleObjectArray[n6];
            annotationArray2 = ((Method)m).getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type = a.annotationType();
                if (this.knownConstraints.contains(type)) {
                    return true;
                }
                annotationArray = type.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.knownConstraints.add(type);
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        accessibleObjectArray = ReflectionUtils.getDeclaredConstructors(clazz);
        n5 = accessibleObjectArray.length;
        n6 = 0;
        while (n6 < n5) {
            AccessibleObject c = accessibleObjectArray[n6];
            annotationArray2 = ((Constructor)c).getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type = a.annotationType();
                if (this.knownConstraints.contains(type)) {
                    return true;
                }
                annotationArray = type.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.knownConstraints.add(type);
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        return false;
    }

    private void ensureValidationXmlWasParsed() {
        while (!xmlParsed) {
            try {
                if (ValidationXMLReader.asyncAttemptFailed() || !ValidationXMLReader.latch.await(10L, TimeUnit.MILLISECONDS)) {
                    ValidationXMLReader.runSynchronouslyForced();
                }
                xmlParsed = true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

