/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.collections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Location {
    private String area;
    private String city;
    private BigDecimal id;
    public PropertyChangeListener listener;

    public PropertyChangeListener getTrackedPropertyChangeListener() {
        return this.listener;
    }

    public void setTrackedPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public static Location example1() {
        Location example1 = new Location();
        example1.setArea("Rideau Centre");
        example1.setCity("Ottawa");
        return example1;
    }

    public static Location example2() {
        Location example2 = new Location();
        example2.setArea("West Edmonton Mall");
        example2.setCity("Edmonton");
        return example2;
    }

    public static Location example3() {
        Location example3 = new Location();
        example3.setArea("Sparks Street Mall");
        example3.setCity("Ottawa");
        return example3;
    }

    public static Location example4() {
        Location example4 = new Location();
        example4.setArea("Eaton's Centre");
        example4.setCity("Toronto");
        return example4;
    }

    public static Location example5() {
        Location example5 = new Location();
        example5.setArea("Old City");
        example5.setCity("Montreal");
        return example5;
    }

    public static Location example6() {
        Location example6 = new Location();
        example6.setArea("Waterfront");
        example6.setCity("Halifax");
        return example6;
    }

    public String getArea() {
        return this.area;
    }

    public String getCity() {
        return this.city;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public static TableDefinition relationTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_R_LO");
        definition.addPrimaryKeyField("LOCA_ID", BigDecimal.class);
        definition.addPrimaryKeyField("REST_ID", BigDecimal.class);
        return definition;
    }

    public static TableDefinition relation2TableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_R_LO2");
        definition.addPrimaryKeyField("LOCA_ID", BigDecimal.class);
        definition.addPrimaryKeyField("REST_ID", BigDecimal.class);
        return definition;
    }

    public void setArea(String newValue) {
        this.propertyChange("area", this.area, newValue);
        this.area = newValue;
    }

    public void setCity(String newValue) {
        this.propertyChange("city", this.city, newValue);
        this.city = newValue;
    }

    public void setId(BigDecimal newValue) {
        this.id = newValue;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("COL_LOCA");
        definition.addIdentityField("ID", BigDecimal.class);
        definition.addField("AREA", String.class, 40);
        definition.addField("CITY", String.class, 40);
        return definition;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Helper.getShortClassName(this.getClass()));
        buf.append("(");
        if (this.getArea() != null) {
            buf.append(this.getArea());
        }
        buf.append(",");
        if (this.getCity() != null) {
            buf.append(this.getCity());
        }
        buf.append(")");
        return buf.toString();
    }
}

