/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class DescriptorRefreshCacheOnRemoteTest
extends ReadObjectTest {
    protected PolicyHolder holder1;
    protected PolicyHolder holder2;

    public DescriptorRefreshCacheOnRemoteTest() {
        this.setName("DescriptorRefreshCacheTestOnRemote");
        this.setDescription("This test case tests remote session refresh cache hit property on descriptor.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ClassDescriptor holderDescriptor = this.getSession().getDescriptor(PolicyHolder.class);
        holderDescriptor.alwaysRefreshCacheOnRemote();
        holderDescriptor.disableCacheHitsOnRemote();
    }

    public void test() {
        this.holder1 = (PolicyHolder)this.getSession().readObject(PolicyHolder.class);
        this.holder1.setAddress(null);
        this.holder1.setFirstName("Yahoo!");
        this.holder1.setPolicies(null);
        this.holder2 = (PolicyHolder)this.getSession().readObject((Object)this.holder1);
    }

    public void verify() {
        if (this.holder2.getPolicies() == null || this.holder2.getAddress() == null || this.holder2.getFirstName() == "Yahoo!") {
            throw new TestErrorException("Refresh object on remote fails");
        }
    }
}

