/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionManagerTest
extends TestCase {
    @Before
    public void setUp() {
        ((ConcurrentMap)this.getField("managers", null)).clear();
    }

    @After
    public void tearDown() {
        this.resetContextHelper();
    }

    @Test
    public void testManagersCaching() {
        ConcurrentMap registeredManagers = (ConcurrentMap)this.getField("managers", null);
        Assert.assertTrue((boolean)registeredManagers.isEmpty());
        this.setContextHelper();
        ICtx.ctx = "test";
        SessionManager m1 = SessionManager.getManager();
        Assert.assertNotNull((Object)m1);
        Assert.assertEquals((long)1L, (long)registeredManagers.size());
        ICtx.ctx = "test2";
        SessionManager m2 = SessionManager.getManager();
        Assert.assertNotNull((Object)m2);
        Assert.assertEquals((long)2L, (long)registeredManagers.size());
        Assert.assertFalse((m1 == m2 ? 1 : 0) != 0);
        ICtx.ctx = "test";
        SessionManager m3 = SessionManager.getManager();
        Assert.assertNotNull((Object)m3);
        Assert.assertEquals((long)2L, (long)registeredManagers.size());
        Assert.assertEquals((Object)m1, (Object)m3);
        Assert.assertTrue((m1 == m3 ? 1 : 0) != 0);
        m1.destroy();
        m2.destroy();
        Assert.assertTrue((boolean)registeredManagers.isEmpty());
    }

    @Test
    public void testManagersCachingWithCustomManager() {
        ConcurrentMap registeredManagers = (ConcurrentMap)this.getField("managers", null);
        Assert.assertTrue((boolean)registeredManagers.isEmpty());
        this.setContextHelper();
        ICtx.ctx = "test3";
        SessionManager.setManager((SessionManager)new SM());
        SessionManager m1 = SessionManager.getManager();
        Assert.assertNotNull((Object)m1);
        Assert.assertNotNull((Object)this.getField("context", m1));
        Assert.assertEquals((Object)"test3", (Object)this.getField("context", m1));
        Assert.assertEquals((long)1L, (long)registeredManagers.size());
        Assert.assertTrue((boolean)(m1 instanceof SM));
        ICtx.ctx = "test4";
        SessionManager m2 = SessionManager.getManager();
        Assert.assertNotNull((Object)m2);
        Assert.assertNotNull((Object)this.getField("context", m2));
        Assert.assertEquals((Object)"test4", (Object)this.getField("context", m2));
        Assert.assertEquals((long)2L, (long)registeredManagers.size());
        Assert.assertFalse((boolean)(m2 instanceof SM));
        Assert.assertFalse((m1 == m2 ? 1 : 0) != 0);
        ICtx.ctx = "test3";
        Assert.assertEquals((Object)m1, (Object)SessionManager.getManager());
        m1.destroy();
        m2.destroy();
        Assert.assertTrue((boolean)registeredManagers.isEmpty());
    }

    @Test
    public void testAllManagers() {
        ConcurrentMap registeredManagers = (ConcurrentMap)this.getField("managers", null);
        Assert.assertTrue((boolean)registeredManagers.isEmpty());
        Collection allManagers = SessionManager.getAllManagers();
        Assert.assertEquals((long)0L, (long)allManagers.size());
        this.setContextHelper();
        ICtx.ctx = "test5";
        SessionManager.setManager((SessionManager)new SM());
        SessionManager m1 = SessionManager.getManager();
        Assert.assertEquals((long)1L, (long)allManagers.size());
        ICtx.ctx = "test6";
        SessionManager m2 = SessionManager.getManager();
        Assert.assertEquals((long)2L, (long)SessionManager.getAllManagers().size());
        ICtx.ctx = "test5";
        Assert.assertEquals((Object)m1, (Object)SessionManager.getManager());
        m1.destroy();
        m2.destroy();
        Assert.assertEquals((long)0L, (long)allManagers.size());
    }

    @Test
    public void testConcextHelper() {
        Class<?> contextHelperClass = null;
        for (Class<?> declaredClass : SessionManager.class.getDeclaredClasses()) {
            if (!declaredClass.getName().equals("org.eclipse.persistence.sessions.factories.SessionManager$ContextHelper")) continue;
            contextHelperClass = declaredClass;
            break;
        }
        Assert.assertNotNull((String)"ContextHelper class not found", contextHelperClass);
        Method getCicManagerClassMethod = null;
        try {
            getCicManagerClassMethod = contextHelperClass.getDeclaredMethod("getCicManagerClass", String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("getCicManagerClass method not found: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"getCicManagerClass method not found", (Object)getCicManagerClassMethod);
        getCicManagerClassMethod.setAccessible(true);
        Object result = null;
        try {
            result = getCicManagerClassMethod.invoke(contextHelperClass, "org/eclipse/persistence/testing/tests/sessionsxml/SessionManagerTest.class", "org.eclipse.persistence.testing.tests.sessionsxml.SessionManagerTest");
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to invoke getCicManagerClass method: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Failed to retrieve test class", (Object)result);
        try {
            result = getCicManagerClassMethod.invoke(contextHelperClass, "this/should/not/resolve", "org.eclipse.persistence.testing.tests.sessionsxml.SessionManagerTest");
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to invoke getCicManagerClass method: " + e.getMessage()));
        }
        Assert.assertNull((String)"Should have failed to retrieve test class", (Object)result);
        getCicManagerClassMethod.setAccessible(false);
    }

    private Object getField(String field, Object o) {
        Field f = null;
        try {
            f = SessionManager.class.getDeclaredField(field);
            f.setAccessible(true);
            Object object = f.get(o);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private void setContextHelper() {
        try {
            this.setPrivateStaticFinalField(SessionManager.class.getDeclaredField("ctxHelper"), this.setUpCtxHelper());
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void resetContextHelper() {
        try {
            this.setPrivateStaticFinalField(SessionManager.class.getDeclaredField("ctxHelper"), null);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object setUpCtxHelper() {
        IMgr imgr = new IMgr();
        Constructor<?> c = null;
        Field instanceField = null;
        Object ctxHelperInstance = null;
        try {
            Class<?> ctxHelperClass = Class.forName("org.eclipse.persistence.sessions.factories.SessionManager$ContextHelper");
            c = ctxHelperClass.getDeclaredConstructors()[0];
            c.setAccessible(true);
            ctxHelperInstance = c.newInstance(imgr.getClass(), ICtx.class.getName());
            this.setPrivateStaticFinalField(ctxHelperClass.getDeclaredField("cicManagerClass"), IMgr.class);
            instanceField = ctxHelperClass.getDeclaredField("instance");
            instanceField.setAccessible(true);
            instanceField.set(null, ctxHelperInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (c != null) {
                c.setAccessible(false);
            }
            if (instanceField != null) {
                instanceField.setAccessible(false);
            }
        }
        return ctxHelperInstance;
    }

    private void setPrivateStaticFinalField(Field f, Object value) {
        Field modifiersField = null;
        try {
            f.setAccessible(true);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (modifiersField != null) {
                if (f != null) {
                    try {
                        modifiersField.setInt(f, f.getModifiers() & 0x10);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                modifiersField.setAccessible(false);
            }
            if (f != null) {
                f.setAccessible(false);
            }
        }
    }

    private static final class ICtx {
        static String ctx;

        public String getPartitionId() {
            return ctx;
        }
    }

    private static final class IMgr {
        private IMgr() {
        }

        public static IMgr getInstance() {
            return new IMgr();
        }

        public ICtx getCurrentComponentInvocationContext() {
            return new ICtx();
        }
    }

    private static final class SM
    extends SessionManager {
    }
}

