/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Engineer;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritancePopulator;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class AdvancedQueryTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public AdvancedQueryTestSuite() {
    }

    public AdvancedQueryTestSuite(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedQueryTestSuite");
        suite.addTest((Test)new AdvancedQueryTestSuite("testSetup"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheFirstCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheOnlyCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCacheOnlyCacheHitsOnSession"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPrimaryKeyCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryExactPrimaryKeyCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryTypeCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryCache"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryREADLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryWRITELock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryOPTIMISTICLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryOPTIMISTIC_FORCE_INCREMENTLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTIC_READLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTIC_WRITELock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTIC_READ_TIMEOUTLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTIC_WRITE_TIMEOUTLock"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTICLockWithLimit"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testObjectResultType"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testNativeResultType"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testCursors"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testFetchGroups"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMultipleNamedJoinFetchs"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testNativeQueryTransactions"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testLockWithSecondaryTable"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingJOIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingEXISTS"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingIN5"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingIN2"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingCursor"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingPagination"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingPagination2"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingReadObject"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingInheritance"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBasicMapBatchFetchingJOIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBasicMapBatchFetchingEXISTS"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBasicMapBatchFetchingIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapBatchFetchingJOIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapBatchFetchingEXISTS"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapBatchFetchingIN"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchingINCache"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBasicMapJoinFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBasicMapLeftJoinFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testBatchFetchOuterJoin"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testJoinFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapJoinFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testJoinFetchingCursor"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testJoinFetchingPagination"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapKeyJoinFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testMapKeyBatchFetching"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testJPQLCacheHits"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testCacheIndexes"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testSQLHint"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testLoadGroup"));
        suite.addTest((Test)new AdvancedQueryTestSuite("testConcurrentLoadGroup"));
        if (!AdvancedQueryTestSuite.isJPA10()) {
            suite.addTest((Test)new AdvancedQueryTestSuite("testQueryPESSIMISTIC_FORCE_INCREMENTLock"));
            suite.addTest((Test)new AdvancedQueryTestSuite("testVersionChangeWithReadLock"));
            suite.addTest((Test)new AdvancedQueryTestSuite("testVersionChangeWithWriteLock"));
            suite.addTest((Test)new AdvancedQueryTestSuite("testNamedQueryAnnotationOverwritePersistenceXML"));
        }
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        new RelationshipsExamples().buildExamples((Session)session);
        new InheritanceTableCreator().replaceTables((DatabaseSession)session);
        InheritancePopulator inheritancePopulator = new InheritancePopulator();
        inheritancePopulator.buildExamples();
        inheritancePopulator.persistExample((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPrimaryKeyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheByPrimaryKey");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSQLHint() {
        if (!this.getDatabaseSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            Query query = em.createNamedQuery("findAllAddressesByPostalCode");
            query.setParameter("postalcode", (Object)"K2H8C2");
            query.getResultList();
            if (((String)counter.getSqlStatements().get(0)).indexOf("/*") == -1) {
                AdvancedQueryTestSuite.fail((String)("SQL hint was not used: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryTypeCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroups() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.id = :id");
            query.setHint("eclipselink.fetch-group.attribute", (Object)"firstName");
            query.setHint("eclipselink.fetch-group.attribute", (Object)"lastName");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("More than fetch group selected: " + counter.getSqlStatements()));
            }
            queryResult.getGender();
            if (counter.getSqlStatements().size() != 2) {
                AdvancedQueryTestSuite.fail((String)("Access to unfetch did not cause fetch: " + counter.getSqlStatements()));
            }
            this.verifyObject(employee);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleNamedJoinFetchs() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            this.clearCache();
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            Query query = em.createNamedQuery("findAllEmployeesJoinAddressPhones");
            List result = query.getResultList();
            if (counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("More than join fetches selected: " + counter.getSqlStatements()));
            }
            for (Employee each : result) {
                each.getAddress().getCity();
                each.getPhoneNumbers().size();
            }
            if (counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Join fetches triggered query: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursors() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            query.setHint("eclipselink.cursor", (Object)true);
            query.setHint("eclipselink.cursor.initial-size", (Object)2);
            query.setHint("eclipselink.cursor.page-size", (Object)5);
            query.setHint("eclipselink.cursor.size-sql", (Object)"Select count(*) from CMP3_EMPLOYEE");
            Cursor cursor = (Cursor)query.getSingleResult();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            JpaQuery jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery("Select employee from Employee employee");
            jpaQuery.setHint("eclipselink.cursor", (Object)true);
            cursor = jpaQuery.getResultCursor();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery("Select employee from Employee employee");
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-concurrency", (Object)"ReadOnly");
            String resultSetType = "ScrollInsensitive";
            if (this.getPlatform().isHANA()) {
                resultSetType = "ForwardOnly";
            }
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)resultSetType);
            ScrollableCursor scrollableCursor = (ScrollableCursor)jpaQuery.getResultCursor();
            scrollableCursor.next();
            scrollableCursor.close();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectResultType() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List listResult;
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            query = em.createQuery("Select employee, employee.address, employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Object[] arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 3 && arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 3 || arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            query = em.createQuery("Select employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            query = em.createQuery("Select employee, employee.address, employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Map mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            query = em.createQuery("Select employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.query-type", (Object)"Report");
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult[0] != employee) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            query = em.createQuery("Select employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Object valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            query = em.createQuery("Select employee.id, employee.firstName from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.result-type", (Object)"Value");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            query = em.createQuery("Select employee.id from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setHint("eclipselink.result-type", (Object)"Attribute");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeResultType() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List listResult;
            Query query = em.createNativeQuery("Select * from CMP3_EMPLOYEE employee", Employee.class);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            query = em.createNativeQuery("Select employee.F_NAME, employee.EMP_ID from CMP3_EMPLOYEE employee where employee.EMP_ID = ? and employee.F_NAME = ?");
            query.setParameter(1, (Object)employee.getId());
            query.setParameter(2, (Object)employee.getFirstName());
            Object[] arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 2 || !arrayResult[0].equals(employee.getFirstName()) && !arrayResult[1].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 2 || !arrayResult[0].equals(employee.getFirstName()) && !arrayResult[1].equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            query = em.createNativeQuery("Select employee.EMP_ID from CMP3_EMPLOYEE employee where employee.EMP_ID = ? and employee.F_NAME = ?");
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter(1, (Object)employee.getId());
            query.setParameter(2, (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 1 || !new Integer(((Number)arrayResult[0]).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 1 || !new Integer(((Number)arrayResult[0]).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            query = em.createNativeQuery("Select employee.F_NAME, employee.EMP_ID from CMP3_EMPLOYEE employee where employee.EMP_ID = ? and employee.F_NAME = ?");
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter(1, (Object)employee.getId());
            query.setParameter(2, (Object)employee.getFirstName());
            Map mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 2 || !mapResult.get("F_NAME").equals(employee.getFirstName()) || !new Integer(((Number)mapResult.get("EMP_ID")).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 2 || !mapResult.get("F_NAME").equals(employee.getFirstName()) || !new Integer(((Number)mapResult.get("EMP_ID")).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            query = em.createNativeQuery("Select employee.EMP_ID from CMP3_EMPLOYEE employee where employee.EMP_ID = ? and employee.F_NAME = ?");
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter(1, (Object)employee.getId());
            query.setParameter(2, (Object)employee.getFirstName());
            mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 1 || !new Integer(((Number)mapResult.get("EMP_ID")).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 1 || !new Integer(((Number)mapResult.get("EMP_ID")).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            query = em.createNativeQuery("Select employee.EMP_ID from CMP3_EMPLOYEE employee where employee.EMP_ID = ? and employee.F_NAME = ?");
            query.setParameter(1, (Object)employee.getId());
            query.setParameter(2, (Object)employee.getFirstName());
            Object valueResult = query.getSingleResult();
            if (!new Integer(((Number)valueResult).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!new Integer(((Number)(valueResult = (listResult = query.getResultList()).get(0))).intValue()).equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryExactPrimaryKeyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.id = :id");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheByExactPrimaryKey");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeQueryTransactions() {
        Employee emp = (Employee)AdvancedQueryTestSuite.getServerSession().readObject(Employee.class);
        if (emp == null) {
            AdvancedQueryTestSuite.fail((String)"Test problem: no Employees in the db, nothing to update");
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.setFlushMode(FlushModeType.COMMIT);
            Query query = em.createNativeQuery("Update CMP3_EMPLOYEE set F_NAME = 'Bobo' where EMP_ID = " + emp.getId());
            query.executeUpdate();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            query = em.createNativeQuery("Select * from CMP3_EMPLOYEE where F_NAME = 'Bobo' AND EMP_ID = " + emp.getId());
            if (query.getResultList().size() == 0) {
                AdvancedQueryTestSuite.fail((String)"Native query did not commit transaction.");
            } else {
                em.setFlushMode(FlushModeType.COMMIT);
                query = em.createNativeQuery("Update CMP3_EMPLOYEE set F_NAME = '" + emp.getFirstName() + "' where EMP_ID = " + emp.getId());
                query.executeUpdate();
                this.commitTransaction(em);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheFirstCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.firstName = :firstName");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            if (!queryResult.getFirstName().equals(employee.getFirstName())) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.firstName = :firstName");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("firstName", (Object)employee.getFirstName());
            query.getResultList();
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHitsOnSession() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            query = em.createQuery("Select employee from Employee employee where employee.id = :id");
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getSingleResult() == null) {
                AdvancedQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            query = em.createQuery("Select employee from Employee employee where employee.id = :id");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getResultList().size() != 1) {
                AdvancedQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCache() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Calendar calendar;
            JpaQuery jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createNamedQuery("CachedAllEmployees");
            List result = jpaQuery.getResultList();
            ReadQuery readQuery = (ReadQuery)jpaQuery.getDatabaseQuery();
            if (readQuery.getQueryResultsCachePolicy() == null) {
                AdvancedQueryTestSuite.fail((String)"Query cache not set.");
            }
            if (readQuery.getQueryResultsCachePolicy().getMaximumCachedResults() != 200) {
                AdvancedQueryTestSuite.fail((String)"Query cache size not set.");
            }
            if (!(readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy() instanceof TimeToLiveCacheInvalidationPolicy)) {
                AdvancedQueryTestSuite.fail((String)"Query cache invalidation not set.");
            }
            if (((TimeToLiveCacheInvalidationPolicy)readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy()).getTimeToLive() != 50000L) {
                AdvancedQueryTestSuite.fail((String)"Query cache invalidation time not set.");
            }
            if ((readQuery = (ReadQuery)(jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createNamedQuery("CachedTimeOfDayAllEmployees")).getDatabaseQuery()).getQueryResultsCachePolicy() == null) {
                AdvancedQueryTestSuite.fail((String)"Query cache not set.");
            }
            if (readQuery.getQueryResultsCachePolicy().getMaximumCachedResults() != 200) {
                AdvancedQueryTestSuite.fail((String)"Query cache size not set.");
            }
            if (!(readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy() instanceof DailyCacheInvalidationPolicy)) {
                AdvancedQueryTestSuite.fail((String)"Query cache invalidation not set.");
            }
            if ((calendar = ((DailyCacheInvalidationPolicy)readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy()).getExpiryTime()).get(11) != 23 && calendar.get(12) != 59 && calendar.get(13) != 59) {
                AdvancedQueryTestSuite.fail((String)"Query cache invalidation time not set.");
            }
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            Query query = em.createNamedQuery("CachedAllEmployees");
            if (result.size() != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"List result size is not correct on 2nd cached query.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Query cache was not used: " + counter.getSqlStatements()));
            }
            this.clearCache();
            em.createQuery("Select e from Employee e").getResultList();
            query.getResultList();
            if (result.size() != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"List result size is not correct on cached query in unit of work.");
            }
            this.clearCache();
            em.persist((Object)new Address());
            em.flush();
            query.getResultList();
            if (result.size() != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"List result size is not correct on cached query in transaction.");
            }
            if (!(query = em.createNamedQuery("CachedNoEmployees")).getResultList().isEmpty()) {
                AdvancedQueryTestSuite.fail((String)"List result size is not correct.");
            }
            counter.remove();
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            if (!query.getResultList().isEmpty()) {
                AdvancedQueryTestSuite.fail((String)"List result size is not correct.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Query cache was not used: " + counter.getSqlStatements()));
            }
            this.rollbackTransaction(em);
            this.beginTransaction(em);
            query = em.createNamedQuery("CachedEmployeeJoinAddress");
            result = query.getResultList();
            Employee employee = new Employee();
            Address address = new Address();
            address.setCity("Ottawa");
            employee.setAddress(address);
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.beginTransaction(em);
            query = em.createNamedQuery("CachedEmployeeJoinAddress");
            if (result.size() + 1 != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"Query result cache not invalidated.");
            }
            address = (Address)em.merge((Object)address);
            address.setCity("nowhere");
            this.commitTransaction(em);
            this.beginTransaction(em);
            query = em.createNamedQuery("CachedEmployeeJoinAddress");
            if (result.size() != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"Query result cache not invalidated.");
            }
            em.remove(em.find(Employee.class, (Object)employee.getId()));
            this.commitTransaction(em);
            query = em.createNamedQuery("CachedEmployeeJoinAddress");
            if (result.size() != query.getResultList().size()) {
                AdvancedQueryTestSuite.fail((String)"Query result cache not invalidated on delete.");
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    public void testQueryREADLock() {
        if (AdvancedQueryTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        List result = em.createQuery("Select employee from Employee employee").getResultList();
        Employee employee = (Employee)result.get(0);
        PersistenceException optimisticLockException = null;
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setLockMode(LockModeType.READ);
            query.setHint("eclipselink.refresh", (Object)true);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            queryResult.toString();
            EntityManager em2 = this.createEntityManager();
            try {
                this.beginTransaction(em2);
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                employee2.setFirstName("Read");
                this.commitTransaction(em2);
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em2);
                throw ex;
            }
            finally {
                this.closeEntityManager(em2);
            }
            try {
                em.flush();
            }
            catch (PersistenceException exception) {
                if (exception instanceof OptimisticLockException) {
                    optimisticLockException = exception;
                }
                throw exception;
            }
            this.rollbackTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.READ is used.", (optimisticLockException == null ? 1 : 0) != 0);
    }

    public void testQueryWRITELock() {
        if (AdvancedQueryTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        List result = em.createQuery("Select employee from Employee employee").getResultList();
        Employee employee = (Employee)result.get(0);
        RollbackException optimisticLockException = null;
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
            query.setLockMode(LockModeType.WRITE);
            query.setHint("eclipselink.refresh", (Object)true);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            EntityManager em2 = this.createEntityManager();
            try {
                this.beginTransaction(em2);
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)queryResult.getId());
                employee2.setFirstName("Write");
                this.commitTransaction(em2);
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em2);
                this.closeEntityManager(em2);
                throw ex;
            }
            this.commitTransaction(em);
        }
        catch (RollbackException exception) {
            if (exception.getCause() instanceof OptimisticLockException) {
                optimisticLockException = exception;
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.WRITE is used.", (optimisticLockException == null ? 1 : 0) != 0);
    }

    public void testQueryOPTIMISTICLock() {
        if (!AdvancedQueryTestSuite.isOnServer()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            PersistenceException optimisticLockException = null;
            try {
                this.beginTransaction(em);
                Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                query.setLockMode(LockModeType.OPTIMISTIC);
                query.setHint("eclipselink.refresh", (Object)true);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                Employee queryResult = (Employee)query.getSingleResult();
                queryResult.toString();
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                    employee2.setFirstName("Optimistic");
                    this.commitTransaction(em2);
                }
                catch (RuntimeException ex) {
                    this.rollbackTransaction(em2);
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em2);
                }
                try {
                    em.flush();
                }
                catch (PersistenceException exception) {
                    if (exception instanceof OptimisticLockException) {
                        optimisticLockException = exception;
                    }
                    throw exception;
                }
                this.rollbackTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.READ is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    public void testQueryOPTIMISTIC_FORCE_INCREMENTLock() {
        if (!AdvancedQueryTestSuite.isOnServer()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            RollbackException optimisticLockException = null;
            try {
                this.beginTransaction(em);
                Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                query.setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
                query.setHint("eclipselink.refresh", (Object)true);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                Employee queryResult = (Employee)query.getSingleResult();
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    Employee employee2 = (Employee)em2.find(Employee.class, (Object)queryResult.getId());
                    employee2.setFirstName("OptimisticForceIncrement");
                    this.commitTransaction(em2);
                }
                catch (RuntimeException ex) {
                    this.rollbackTransaction(em2);
                    this.closeEntityManager(em2);
                    throw ex;
                }
                this.commitTransaction(em);
            }
            catch (RollbackException exception) {
                if (exception.getCause() instanceof OptimisticLockException) {
                    optimisticLockException = exception;
                }
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.WRITE is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPESSIMISTIC_READLock() {
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        if (!AdvancedQueryTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            PessimisticLockException pessimisticLockException = null;
            try {
                this.beginTransaction(em);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    List employees2 = em2.createQuery("Select employee from Employee employee").getResultList();
                    Employee employee2 = (Employee)employees2.get(0);
                    List employees = em.createQuery("Select employee from Employee employee").setLockMode(LockModeType.PESSIMISTIC_READ).getResultList();
                    Employee employee = (Employee)employees.get(0);
                    employee.setFirstName("New Pessimistic Employee");
                    HashMap<String, Integer> properties = new HashMap<String, Integer>();
                    properties.put("javax.persistence.lock.timeout", 0);
                    em2.lock((Object)employee2, LockModeType.PESSIMISTIC_READ, properties);
                    employee2.setFirstName("Invalid Lock Employee");
                    this.commitTransaction(em2);
                }
                catch (PessimisticLockException ex) {
                    pessimisticLockException = ex;
                }
                finally {
                    this.closeEntityManagerAndTransaction(em2);
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPESSIMISTIC_WRITELock() {
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        if (!AdvancedQueryTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            PessimisticLockException pessimisticLockException = null;
            try {
                this.beginTransaction(em);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    List employees2 = em2.createQuery("Select employee from Employee employee").getResultList();
                    Employee employee2 = (Employee)employees2.get(0);
                    List employees = em.createQuery("Select employee from Employee employee").setLockMode(LockModeType.PESSIMISTIC_READ).getResultList();
                    Employee employee = (Employee)employees.get(0);
                    employee.setFirstName("New Pessimistic Employee");
                    HashMap<String, Integer> properties = new HashMap<String, Integer>();
                    properties.put("javax.persistence.lock.timeout", 0);
                    em2.lock((Object)employee2, LockModeType.PESSIMISTIC_READ, properties);
                    employee2.setFirstName("Invalid Lock Employee");
                    this.commitTransaction(em2);
                }
                catch (PessimisticLockException ex) {
                    pessimisticLockException = ex;
                }
                finally {
                    this.closeEntityManagerAndTransaction(em2);
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    public void testQueryPESSIMISTIC_FORCE_INCREMENTLock() {
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        if (this.isSelectForUpateSupported()) {
            Employee queryResult;
            Query query;
            Employee employee = null;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                employee = new Employee();
                employee.setFirstName("Guillaume");
                employee.setLastName("Aujet");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            Integer version1 = employee.getVersion();
            try {
                this.beginTransaction(em);
                query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName").setLockMode(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                query.setHint("eclipselink.refresh", (Object)true);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                queryResult = (Employee)query.getSingleResult();
                queryResult.setLastName("Auger");
                this.commitTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                AdvancedQueryTestSuite.assertTrue((String)"The version was not updated on the pessimistic lock.", (version1 < employee.getVersion() ? 1 : 0) != 0);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            try {
                this.beginTransaction(em);
                query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName").setLockMode(LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                queryResult = (Employee)query.getSingleResult();
                this.rollbackTransaction(em);
                AdvancedQueryTestSuite.assertTrue((String)"The last name is not updated by using PESSIMISTIC_FORCE_INCREMENT.", (boolean)queryResult.getLastName().equals("Auger"));
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPESSIMISTIC_READ_TIMEOUTLock() {
        ServerSession session = JUnitTestCase.getServerSession();
        if (!AdvancedQueryTestSuite.isOnServer() && session.getPlatform().isOracle()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            PersistenceException lockTimeOutException = null;
            try {
                block13: {
                    this.beginTransaction(em);
                    Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                    query.setLockMode(LockModeType.PESSIMISTIC_READ);
                    query.setHint("eclipselink.refresh", (Object)true);
                    query.setParameter("id", (Object)employee.getId());
                    query.setParameter("firstName", (Object)employee.getFirstName());
                    Employee queryResult = (Employee)query.getSingleResult();
                    queryResult.toString();
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Query query2 = em2.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                        query2.setLockMode(LockModeType.PESSIMISTIC_READ);
                        query2.setHint("eclipselink.refresh", (Object)true);
                        query2.setHint("javax.persistence.lock.timeout", (Object)5);
                        query2.setParameter("id", (Object)employee.getId());
                        query2.setParameter("firstName", (Object)employee.getFirstName());
                        Employee employee2 = (Employee)query2.getSingleResult();
                        employee2.setFirstName("Invalid Lock Employee");
                        this.commitTransaction(em2);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof LockTimeoutException) {
                            lockTimeOutException = ex;
                            break block13;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (lockTimeOutException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPESSIMISTIC_WRITE_TIMEOUTLock() {
        ServerSession session = JUnitTestCase.getServerSession();
        if (!AdvancedQueryTestSuite.isOnServer() && session.getPlatform().isOracle()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            PersistenceException lockTimeOutException = null;
            try {
                block13: {
                    this.beginTransaction(em);
                    Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                    query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
                    query.setHint("eclipselink.refresh", (Object)true);
                    query.setParameter("id", (Object)employee.getId());
                    query.setParameter("firstName", (Object)employee.getFirstName());
                    Employee queryResult = (Employee)query.getSingleResult();
                    queryResult.toString();
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Query query2 = em2.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName");
                        query2.setLockMode(LockModeType.PESSIMISTIC_WRITE);
                        query2.setHint("eclipselink.refresh", (Object)true);
                        query2.setHint("javax.persistence.lock.timeout", (Object)5);
                        query2.setParameter("id", (Object)employee.getId());
                        query2.setParameter("firstName", (Object)employee.getFirstName());
                        Employee employee2 = (Employee)query2.getSingleResult();
                        employee2.setFirstName("Invalid Lock Employee");
                        this.commitTransaction(em2);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof LockTimeoutException) {
                            lockTimeOutException = ex;
                            break block13;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (lockTimeOutException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockWithSecondaryTable() {
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        if (!AdvancedQueryTestSuite.isOnServer() && this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            PessimisticLockException pessimisticLockException = null;
            try {
                this.beginTransaction(em);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    List employees2 = em2.createQuery("Select employee from Employee employee").getResultList();
                    Employee employee2 = (Employee)employees2.get(0);
                    List employees = em.createQuery("Select employee from Employee employee").setLockMode(LockModeType.PESSIMISTIC_WRITE).getResultList();
                    Employee employee = (Employee)employees.get(0);
                    employee.setSalary(90000);
                    HashMap<String, Integer> properties = new HashMap<String, Integer>();
                    properties.put("javax.persistence.lock.timeout", 0);
                    em2.lock((Object)employee2, LockModeType.PESSIMISTIC_WRITE, properties);
                    employee2.setSalary(100000);
                    this.commitTransaction(em2);
                }
                catch (PessimisticLockException ex) {
                    pessimisticLockException = ex;
                }
                finally {
                    this.closeEntityManagerAndTransaction(em2);
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedQueryTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    public void testVersionChangeWithReadLock() {
        if (this.isSelectForUpateNoWaitSupported()) {
            Employee employee = null;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                employee = new Employee();
                employee.setFirstName("Version Change");
                employee.setLastName("Readlock");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            Integer version1 = employee.getVersion();
            try {
                this.beginTransaction(em);
                Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName").setLockMode(LockModeType.PESSIMISTIC_READ);
                query.setHint("eclipselink.refresh", (Object)true);
                query.setHint("javax.persistence.lock.timeout", (Object)0);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                Employee queryResult = (Employee)query.getSingleResult();
                queryResult.setLastName("Burger");
                this.commitTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                AdvancedQueryTestSuite.assertTrue((String)"The version was not updated on the pessimistic read lock.", (version1 < employee.getVersion() ? 1 : 0) != 0);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    public void testNamedQueryAnnotationOverwritePersistenceXML() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query query = em.createNamedQuery("findAllEmployeesByIdAndFirstName");
            Map hints = query.getHints();
            AdvancedQueryTestSuite.assertTrue((String)"query hint", (boolean)hints.get("javax.persistence.lock.timeout").equals("15"));
            this.rollbackTransaction(em);
        }
        catch (Exception ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testVersionChangeWithWriteLock() {
        if (this.isSelectForUpateNoWaitSupported()) {
            Employee employee = null;
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                employee = new Employee();
                employee.setFirstName("Version Change");
                employee.setLastName("Writelock");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            Integer version1 = employee.getVersion();
            try {
                this.beginTransaction(em);
                Query query = em.createQuery("Select employee from Employee employee where employee.id = :id and employee.firstName = :firstName").setLockMode(LockModeType.PESSIMISTIC_WRITE);
                query.setHint("eclipselink.refresh", (Object)true);
                query.setHint("javax.persistence.lock.timeout", (Object)0);
                query.setParameter("id", (Object)employee.getId());
                query.setParameter("firstName", (Object)employee.getFirstName());
                Employee queryResult = (Employee)query.getSingleResult();
                queryResult.setLastName("Burger");
                this.commitTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                AdvancedQueryTestSuite.assertTrue((String)"The version was not updated on the pessimistic write lock.", (version1 < employee.getVersion() ? 1 : 0) != 0);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    public void testBatchFetchingIN() {
        this.testBatchFetching(BatchFetchType.IN, 1000);
    }

    public void testBatchFetchingIN5() {
        this.testBatchFetching(BatchFetchType.IN, 5);
    }

    public void testBatchFetchingIN2() {
        this.testBatchFetching(BatchFetchType.IN, 2);
    }

    public void testBatchFetchingJOIN() {
        this.testBatchFetching(BatchFetchType.JOIN, 0);
    }

    public void testBatchFetchingEXISTS() {
        this.testBatchFetching(BatchFetchType.EXISTS, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetching(BatchFetchType type, int size) {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e where e.gender = :g1 or e.gender = :g2");
            query.setHint("eclipselink.batch.size", (Object)size);
            query.setHint("eclipselink.batch.type", (Object)type);
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.manager");
            query.setHint("eclipselink.batch", (Object)"e.projects");
            query.setHint("eclipselink.batch", (Object)"e.managedEmployees");
            query.setHint("eclipselink.batch", (Object)"e.responsibilities");
            query.setHint("eclipselink.batch", (Object)"e.dealers");
            query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
            query.setHint("eclipselink.batch", (Object)"e.workWeek");
            query.setParameter("g1", (Object)Employee.Gender.Male);
            query.setParameter("g2", (Object)Employee.Gender.Female);
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            for (Employee employee : results) {
                employee.getAddress();
                employee.getManager();
                employee.getProjects().size();
                employee.getManagedEmployees().size();
                employee.getResponsibilities().size();
                employee.getDealers().size();
                employee.getPhoneNumbers().size();
                employee.getWorkWeek().size();
            }
            int queries = 11;
            if (size == 2) {
                queries = 55;
            } else if (size == 5) {
                queries = 30;
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            if (type != BatchFetchType.JOIN) {
                for (String sql : counter.getSqlStatements()) {
                    if (sql.indexOf("DISTINCT") == -1 || sql.indexOf("PROJ_TYPE") != -1) continue;
                    AdvancedQueryTestSuite.fail((String)("SQL should not contain DISTINCT: " + sql));
                }
            }
            this.clearCache();
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    public void testBatchFetchingINCache() {
        this.testBatchFetchingINCache(1);
        this.testBatchFetchingINCache(2);
        this.testBatchFetchingINCache(3);
        this.testBatchFetchingINCache(4);
        this.testBatchFetchingINCache(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingINCache(int batchSize) {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            Query query = em.createQuery("Select a from Address a where exists (Select e from Employee e where e.address = a and e.gender = :g1)");
            query.setParameter("g1", (Object)Employee.Gender.Female);
            query.getResultList();
            query = em.createQuery("Select e from Employee e where e.gender = :g1 or e.gender = :g2");
            query.setHint("eclipselink.batch.size", (Object)batchSize);
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.manager");
            query.setParameter("g1", (Object)Employee.Gender.Male);
            query.setParameter("g2", (Object)Employee.Gender.Female);
            List results = query.getResultList();
            for (Employee employee : results) {
                employee.getAddress();
                employee.getManager();
            }
            this.clearCache();
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e where e.gender = :g1 or e.gender = :g2");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.address");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.responsibilities");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.dealers");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.phoneNumbers");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.workWeek");
            query.setParameter("g1", (Object)Employee.Gender.Male);
            query.setParameter("g2", (Object)Employee.Gender.Female);
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            for (Employee employee : results) {
                employee.getAddress();
                employee.getResponsibilities().size();
                employee.getDealers().size();
                employee.getPhoneNumbers().size();
                employee.getWorkWeek().size();
            }
            int queries = 1;
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    public void testBasicMapBatchFetchingJOIN() {
        this.testBasicMapBatchFetching(BatchFetchType.JOIN, 0);
    }

    public void testBasicMapBatchFetchingIN() {
        this.testBasicMapBatchFetching(BatchFetchType.IN, 100);
    }

    public void testBasicMapBatchFetchingEXISTS() {
        this.testBasicMapBatchFetching(BatchFetchType.EXISTS, 0);
    }

    public void testMapBatchFetchingJOIN() {
        this.testMapBatchFetching(BatchFetchType.JOIN, 0);
    }

    public void testMapBatchFetchingIN() {
        this.testMapBatchFetching(BatchFetchType.IN, 100);
    }

    public void testMapBatchFetchingEXISTS() {
        this.testMapBatchFetching(BatchFetchType.EXISTS, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMapBatchFetching(BatchFetchType type, int size) {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select b from Buyer b where b.name like :name");
            query.setHint("eclipselink.batch.size", (Object)size);
            query.setHint("eclipselink.batch.type", (Object)type);
            query.setHint("eclipselink.batch", (Object)"e.creditCards");
            query.setHint("eclipselink.batch", (Object)"e.creditLines");
            query.setParameter("name", (Object)"%Gold%");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 3) {
                AdvancedQueryTestSuite.fail((String)("Should have been 3 query but was: " + counter.getSqlStatements().size()));
            }
            for (Buyer buyer : results) {
                buyer.getCreditCards().size();
                buyer.getCreditLines().size();
            }
            int queries = 4;
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Buyer buyer : results) {
                this.verifyObject(buyer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMapJoinFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select b from Buyer b where b.name like :name");
            query.setHint("eclipselink.join-fetch", (Object)"e.creditCards");
            query.setHint("eclipselink.join-fetch", (Object)"e.creditLines");
            query.setParameter("name", (Object)"%Gold%");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 query but was: " + counter.getSqlStatements().size()));
            }
            for (Buyer buyer : results) {
                buyer.getCreditCards().size();
                buyer.getCreditLines().size();
            }
            int queries = 2;
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Buyer buyer : results) {
                this.verifyObject(buyer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicMapLeftJoinFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select b from Buyer b where b.name like :name");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.creditCards");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.creditLines");
            query.setParameter("name", (Object)"%Gold%");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 query but was: " + counter.getSqlStatements().size()));
            }
            boolean found = false;
            for (Buyer buyer : results) {
                found = found || buyer.getCreditCards().size() > 0;
                found = found || buyer.getCreditLines().size() > 0;
            }
            AdvancedQueryTestSuite.assertTrue((String)"No data to join.", (boolean)found);
            int queries = 2;
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Buyer buyer : results) {
                this.verifyObject(buyer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapBatchFetching(BatchFetchType type, int size) {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select c from Customer c");
            query.setHint("eclipselink.batch.size", (Object)size);
            query.setHint("eclipselink.batch.type", (Object)type);
            query.setHint("eclipselink.batch", (Object)"e.CSInteractions");
            query.setHint("eclipselink.batch", (Object)"e.CCustomers");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 3) {
                AdvancedQueryTestSuite.fail((String)("Should have been 3 queries but was: " + counter.getSqlStatements().size()));
            }
            int queries = 5;
            for (Customer customer : results) {
                queries += customer.getCSInteractions().size();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Customer customer : results) {
                this.verifyObject(customer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadGroup() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select c from Customer c");
            query.setHint("eclipselink.load-group.attribute", (Object)"CSInteractions");
            query.setHint("eclipselink.load-group.attribute", (Object)"CCustomers");
            List results = query.getResultList();
            counter.getSqlStatements().clear();
            for (Customer customer : results) {
                customer.getCSInteractions().size();
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)"Load group should have loaded attributes.");
            }
            this.clearCache();
            for (Customer customer : results) {
                this.verifyObject(customer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentLoadGroup() {
        this.clearCache();
        boolean concurrent = this.getDatabaseSession().isConcurrent();
        this.getDatabaseSession().setIsConcurrent(true);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select c from Customer c");
            query.setHint("eclipselink.load-group.attribute", (Object)"CSInteractions");
            query.setHint("eclipselink.load-group.attribute", (Object)"CCustomers");
            List results = query.getResultList();
            counter.getSqlStatements().clear();
            for (Customer customer : results) {
                customer.getCSInteractions().size();
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)"Load group should have loaded attributes.");
            }
            this.clearCache();
            for (Customer customer : results) {
                this.verifyObject(customer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
            this.getDatabaseSession().setIsConcurrent(concurrent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapJoinFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select c from Customer c");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.CSInteractions");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.CCustomers");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 3) {
                AdvancedQueryTestSuite.fail((String)("Should have been 3 queries but was: " + counter.getSqlStatements().size()));
            }
            int queries = 1;
            for (Customer customer : results) {
                queries += customer.getCSInteractions().size();
            }
            AdvancedQueryTestSuite.assertTrue((String)"No data to join.", (queries > 1 ? 1 : 0) != 0);
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Customer customer : results) {
                this.verifyObject(customer);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapKeyJoinFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select d from ADV_DEPT d");
            query.setHint("eclipselink.left-join-fetch", (Object)"d.equipment");
            query.setHint("eclipselink.left-join-fetch", (Object)"d.employees");
            query.setHint("eclipselink.left-join-fetch", (Object)"d.managers");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 13 queries but was: " + counter.getSqlStatements().size()));
            }
            int queries = 1;
            for (Department department : results) {
                queries += department.getEquipment().size();
                department.getEmployees().size();
                department.getManagers().size();
            }
            AdvancedQueryTestSuite.assertTrue((String)"No data to join.", (queries > 1 ? 1 : 0) != 0);
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Department department : results) {
                this.verifyObject(department);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapKeyBatchFetching() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select d from ADV_DEPT d");
            query.setHint("eclipselink.batch", (Object)"d.equipment");
            query.setHint("eclipselink.batch", (Object)"d.employees");
            query.setHint("eclipselink.batch", (Object)"d.managers");
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 queries but was: " + counter.getSqlStatements().size()));
            }
            int queries = 1;
            for (Department department : results) {
                queries += department.getEquipment().size();
                department.getEmployees().size();
                department.getManagers().size();
            }
            AdvancedQueryTestSuite.assertTrue((String)"No data to join.", (queries > 1 ? 1 : 0) != 0);
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 4) {
                AdvancedQueryTestSuite.fail((String)("Should have been 4 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Department department : results) {
                this.verifyObject(department);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingPagination() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.batch.size", (Object)5);
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.manager");
            query.setFirstResult(5);
            query.setMaxResults(5);
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            if (results.size() > 5) {
                AdvancedQueryTestSuite.fail((String)("Should have only returned 5 objects but was: " + results.size()));
            }
            for (Employee employee : results) {
                employee.getAddress();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinFetchingPagination() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.address");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.phoneNumbers");
            query.setFirstResult(5);
            query.setMaxResults(5);
            List results = query.getResultList();
            int nExpectedStatements = 3;
            if (AdvancedQueryTestSuite.usesSOP()) {
                nExpectedStatements = 1;
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != nExpectedStatements) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + nExpectedStatements + " query but was: " + counter.getSqlStatements().size()));
            }
            if (results.size() > 5) {
                AdvancedQueryTestSuite.fail((String)("Should have only returned 5 objects but was: " + results.size()));
            }
            for (Employee employee : results) {
                employee.getAddress();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > nExpectedStatements) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + nExpectedStatements + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            counter.remove();
            counter = null;
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingReadObject() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.batch", (Object)"e.managedEmployees");
            query.setHint("eclipselink.batch", (Object)"e.managedEmployees.address");
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            Employee result = (Employee)query.getSingleResult();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            for (Employee employee : result.getManagedEmployees()) {
                employee.getAddress();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 3) {
                AdvancedQueryTestSuite.fail((String)("Should have been 3 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            this.verifyObject(result);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchOuterJoin() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select p from Person p left join p.bestFriend f order by f.title");
            query.setHint("eclipselink.batch", (Object)"p.bestFriend");
            List result = query.getResultList();
            if (result.size() != 8) {
                AdvancedQueryTestSuite.fail((String)("Should have been 8 results but was: " + result.size()));
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 query but was: " + counter.getSqlStatements().size()));
            }
            for (Person person : result) {
                person.getBestFriend();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Person person : result) {
                this.verifyObject(person);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingInheritance() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select p from Person p");
            query.setHint("eclipselink.batch.type", (Object)BatchFetchType.IN);
            query.setHint("eclipselink.batch", (Object)"p.company");
            List result = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 5) {
                AdvancedQueryTestSuite.fail((String)("Should have been 5 query but was: " + counter.getSqlStatements().size()));
            }
            for (Person person : result) {
                if (!(person instanceof Engineer)) continue;
                ((Engineer)person).getCompany();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 5) {
                AdvancedQueryTestSuite.fail((String)("Should have been 5 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Person person : result) {
                this.verifyObject(person);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingPagination2() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.manager");
            query.setFirstResult(5);
            query.setMaxResults(5);
            List results = query.getResultList();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            if (results.size() > 5) {
                AdvancedQueryTestSuite.fail((String)("Should have only returned 5 objects but was: " + results.size()));
            }
            for (Employee employee : results) {
                employee.getAddress();
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Employee employee : results) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchFetchingCursor() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.batch.type", (Object)String.valueOf(BatchFetchType.IN));
            query.setHint("eclipselink.batch", (Object)"e.address");
            query.setHint("eclipselink.batch", (Object)"e.manager");
            query.setHint("eclipselink.cursor.page-size", (Object)5);
            query.setHint("eclipselink.cursor.initial-size", (Object)2);
            Iterator results = (Iterator)query.getSingleResult();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            int count = 0;
            ArrayList employees = new ArrayList();
            while (results.hasNext()) {
                Employee employee = (Employee)results.next();
                employee.getAddress();
                ++count;
            }
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > count / 5 + 2) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + (count / 5 + 2) + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Employee employee : employees) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinFetchingCursor() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
        try {
            Query query = em.createQuery("Select e from Employee e order by e.id");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.address");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.responsibilities");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.dealers");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.phoneNumbers");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.workWeek");
            query.setHint("eclipselink.cursor.page-size", (Object)5);
            query.setHint("eclipselink.cursor.initial-size", (Object)2);
            Iterator results = (Iterator)query.getSingleResult();
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() != 1) {
                AdvancedQueryTestSuite.fail((String)("Should have been 1 query but was: " + counter.getSqlStatements().size()));
            }
            int count = 0;
            ArrayList<Employee> employees = new ArrayList<Employee>();
            while (results.hasNext()) {
                Employee employee = (Employee)results.next();
                employees.add(employee);
                employee.getAddress();
                employee.getResponsibilities().size();
                employee.getDealers().size();
                employee.getPhoneNumbers().size();
                employee.getWorkWeek().size();
                ++count;
            }
            int queries = 1;
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > queries) {
                AdvancedQueryTestSuite.fail((String)("Should have been " + queries + " queries but was: " + counter.getSqlStatements().size()));
            }
            this.clearCache();
            for (Employee employee : employees) {
                this.verifyObject(employee);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJPQLCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee");
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.id = :id");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (!queryResult.getId().equals(employee.getId())) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit did not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheIndexes() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        Buyer buyer = null;
        Employee employee = null;
        String lastName = null;
        try {
            Query query = em.createQuery("Select employee from Employee employee where employee.lastName = 'Chanley'");
            List result = query.getResultList();
            employee = (Employee)result.get(0);
            lastName = employee.getLastName();
            counter = new QuerySQLTracker((Session)AdvancedQueryTestSuite.getServerSession());
            query = em.createQuery("Select employee from Employee employee where employee.firstName = :firstName and employee.lastName = :lastName");
            query.setParameter("firstName", (Object)employee.getFirstName());
            query.setParameter("lastName", (Object)employee.getLastName());
            counter.getSqlStatements().clear();
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
            employee.setLastName("fail");
            this.commitTransaction(em);
            query = em.createQuery("Select employee from Employee employee where employee.firstName = :firstName and employee.lastName = :lastName");
            query.setParameter("firstName", (Object)employee.getFirstName());
            query.setParameter("lastName", (Object)lastName);
            counter.getSqlStatements().clear();
            try {
                queryResult = null;
                queryResult = (Employee)query.getSingleResult();
            }
            catch (NoResultException ignore) {
                // empty catch block
            }
            if (queryResult != null) {
                AdvancedQueryTestSuite.fail((String)("Employees should not be found, " + queryResult));
            }
            if (counter.getSqlStatements().size() == 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit should not occur: " + counter.getSqlStatements()));
            }
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            buyer = new Buyer();
            buyer.setName("index");
            buyer.setDescription("description");
            em.persist((Object)buyer);
            this.commitTransaction(em);
            query = em.createQuery("Select b from Buyer b where b.name = :name");
            query.setParameter("name", (Object)buyer.getName());
            counter.getSqlStatements().clear();
            Buyer queryResult2 = (Buyer)query.getSingleResult();
            if (!queryResult2.getName().equals(buyer.getName())) {
                AdvancedQueryTestSuite.fail((String)("Buyers are not equal: " + buyer + ", " + queryResult2));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
            this.closeEntityManagerAndTransaction(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            if (buyer != null) {
                buyer = (Buyer)em.find(Buyer.class, (Object)buyer.getId());
                em.remove((Object)buyer);
            }
            if (employee != null) {
                Employee reset = (Employee)em.find(Employee.class, (Object)employee.getId());
                reset.setLastName(lastName);
            }
            this.commitTransaction(em);
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryPESSIMISTICLockWithLimit() throws InterruptedException {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createQuery("Select e from Employee e");
            query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
            query.setFirstResult(5);
            query.setMaxResults(2);
            List results = query.getResultList();
            final Employee e = (Employee)results.get(0);
            String name = e.getFirstName();
            if (results.size() > 2) {
                AdvancedQueryTestSuite.fail((String)("Should have only returned 2 objects but was: " + results.size()));
            }
            this.clearCache();
            final EntityManager em2 = this.createEntityManager();
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                AdvancedQueryTestSuite.this.beginTransaction(em2);
                                Query query2 = em2.createQuery("select e from Employee e where e.id = :id");
                                query2.setParameter("id", (Object)e.getId());
                                query2.setHint("javax.persistence.lock.timeout", (Object)5);
                                Employee emp = (Employee)query2.getSingleResult();
                                emp.setFirstName("Trouba");
                                AdvancedQueryTestSuite.this.commitTransaction(em2);
                            }
                            catch (RollbackException ex) {
                                if (ex.getMessage().indexOf("org.eclipse.persistence.exceptions.DatabaseException") != -1) break block2;
                                ex.printStackTrace();
                                Assert.fail((String)("it's not the right exception:" + (Object)((Object)ex)));
                            }
                        }
                    }
                };
                Thread t2 = new Thread(runnable);
                t2.start();
                Thread.sleep(1000L);
                em.refresh((Object)e);
                AdvancedQueryTestSuite.assertTrue((String)"pessimistic lock failed: parallel transaction modified locked entity (non-repeatable read)", (boolean)name.equals(e.getFirstName()));
                this.rollbackTransaction(em);
                t2.join();
            }
            finally {
                if (this.isTransactionActive(em2)) {
                    this.rollbackTransaction(em2);
                }
                this.closeEntityManager(em2);
            }
        }
        catch (PersistenceException e) {
            if (!(this.getPlatform().isOracle() && e.getCause() instanceof QueryException && e.getCause().getCause() instanceof UnsupportedOperationException)) {
                throw e;
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

