/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.LinkedQueue;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.StatefulCommandExecutor;
import org.eclipse.persistence.tools.utility.reference.SynchronizedBoolean;

public abstract class AbstractQueueingCommandExecutor<E extends StatefulCommandExecutor>
implements StatefulCommandExecutor {
    protected final E commandExecutor;
    protected final SynchronizedBoolean active = new SynchronizedBoolean(false);
    private LinkedQueue<Command> queue = new LinkedQueue();

    protected AbstractQueueingCommandExecutor(E commandExecutor) {
        if (commandExecutor == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
    }

    @Override
    public synchronized void start() {
        if (this.active.isTrue()) {
            throw new IllegalStateException("Not stopped.");
        }
        this.commandExecutor.start();
        while (!this.queue.isEmpty()) {
            this.commandExecutor.execute(this.queue.dequeue());
        }
        this.active.setTrue();
    }

    @Override
    public void execute(Command command) {
        if (this.commandIsToBeExecuted(command)) {
            this.commandExecutor.execute(command);
        }
    }

    private synchronized boolean commandIsToBeExecuted(Command command) {
        if (this.active.isFalse()) {
            this.queue.enqueue(command);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (this.active.isFalse()) {
            throw new IllegalStateException("Not started.");
        }
        this.active.setFalse();
        this.commandExecutor.stop();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.queue);
    }
}

