/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayIterable;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;
import org.eclipse.persistence.tools.utility.iterator.SingleElementIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;

public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterator<? extends Iterator<? extends E>> iterators;
    private Iterator<? extends E> currentIterator;
    private Iterator<? extends E> lastIteratorToReturnNext;

    public CompositeIterator(Iterable<? extends Iterable<? extends E>> iterables) {
        this(new TransformationIterator<Iterable<? extends E>, Iterator<? extends E>>(iterables.iterator()){

            @Override
            protected Iterator<? extends E> transform(Iterable<? extends E> iterable) {
                return iterable.iterator();
            }
        });
    }

    public CompositeIterator(Iterator<? extends Iterator<? extends E>> iterators) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
    }

    public CompositeIterator(E object, Iterable<? extends E> iterable) {
        this((E)object, iterable.iterator());
    }

    public CompositeIterator(E object, Iterator<? extends E> iterator) {
        this(new Iterator[]{new SingleElementIterator<E>(object), iterator});
    }

    public CompositeIterator(Iterable<? extends E> iterable, E object) {
        this(iterable.iterator(), (E)object);
    }

    public CompositeIterator(Iterator<? extends E> iterator, E object) {
        this(new Iterator[]{iterator, new SingleElementIterator<E>(object)});
    }

    public CompositeIterator(Iterable<? extends E> ... iterables) {
        this((Iterable<Iterable<? extends E>>)new ArrayIterable<Iterable<? extends E>>(iterables));
    }

    public CompositeIterator(Iterator<? extends E> ... iterators) {
        this((Iterator<Iterator<? extends E>>)new ArrayIterator<Iterator<? extends E>>(iterators));
    }

    @Override
    public boolean hasNext() {
        try {
            this.loadCurrentIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.loadCurrentIterator();
        E result = this.currentIterator.next();
        this.lastIteratorToReturnNext = this.currentIterator;
        return result;
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturnNext == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnNext.remove();
    }

    private void loadCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.next();
        }
        while (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

