/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import java.util.EmptyStackException;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.Stack;
import org.eclipse.persistence.tools.utility.tests.MultiThreadedTestCase;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public abstract class StackTests
extends MultiThreadedTestCase {
    public StackTests(String name) {
        super(name);
    }

    abstract Stack<String> buildStack();

    public void testIsEmpty() {
        Stack<String> stack = this.buildStack();
        StackTests.assertTrue((boolean)stack.isEmpty());
        stack.push((Object)"first");
        StackTests.assertFalse((boolean)stack.isEmpty());
        stack.push((Object)"second");
        StackTests.assertFalse((boolean)stack.isEmpty());
        stack.pop();
        StackTests.assertFalse((boolean)stack.isEmpty());
        stack.pop();
        StackTests.assertTrue((boolean)stack.isEmpty());
    }

    public void testPushAndPop() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        StackTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackTests.assertEquals((String)first, (String)((String)stack.pop()));
    }

    public void testPushAndPeek() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        StackTests.assertEquals((String)second, (String)((String)stack.peek()));
        StackTests.assertEquals((String)second, (String)((String)stack.peek()));
        StackTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackTests.assertEquals((String)first, (String)((String)stack.peek()));
        StackTests.assertEquals((String)first, (String)((String)stack.peek()));
        StackTests.assertEquals((String)first, (String)((String)stack.pop()));
    }

    public void testEmptyStackExceptionPeek() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        StackTests.assertEquals((String)second, (String)((String)stack.peek()));
        StackTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackTests.assertEquals((String)first, (String)((String)stack.peek()));
        StackTests.assertEquals((String)first, (String)((String)stack.pop()));
        boolean exCaught = false;
        try {
            stack.peek();
            StackTests.fail();
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        StackTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyStackExceptionPop() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        stack.push((Object)first);
        stack.push((Object)second);
        StackTests.assertEquals((String)second, (String)((String)stack.peek()));
        StackTests.assertEquals((String)second, (String)((String)stack.pop()));
        StackTests.assertEquals((String)first, (String)((String)stack.peek()));
        StackTests.assertEquals((String)first, (String)((String)stack.pop()));
        boolean exCaught = false;
        try {
            stack.pop();
            StackTests.fail();
        }
        catch (EmptyStackException emptyStackException) {
            exCaught = true;
        }
        StackTests.assertTrue((boolean)exCaught);
    }

    public void testClone() {
        Stack<String> stack = this.buildStack();
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        Stack clone = (Stack)ObjectTools.execute(stack, (String)"clone");
        this.verifyClone(stack, (Stack<String>)clone);
    }

    public void testSerialization() throws Exception {
        Stack<String> stack = this.buildStack();
        stack.push((Object)"first");
        stack.push((Object)"second");
        stack.push((Object)"third");
        this.verifyClone(stack, TestTools.serialize(stack));
    }

    private void verifyClone(Stack<String> original, Stack<String> clone) {
        StackTests.assertNotSame(original, clone);
        StackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        StackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        StackTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        StackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        StackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        StackTests.assertTrue((boolean)original.isEmpty());
        StackTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.push((Object)"fourth");
        StackTests.assertFalse((boolean)original.isEmpty());
        StackTests.assertTrue((boolean)clone.isEmpty());
    }
}

