/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicCollectionMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;
import org.eclipse.persistence.tools.mapping.orm.ExternalCollectionTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.dom.BatchFetch;
import org.eclipse.persistence.tools.mapping.orm.dom.CollectionTable;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.utility.TextRange;

final class BasicCollectionMapping
extends ConvertibleMapping
implements ExternalBasicCollectionMapping {
    BasicCollectionMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalBatchFetch addBatchFetch() {
        BatchFetch batchFetch = this.buildBatchFetch();
        batchFetch.addSelf();
        return batchFetch;
    }

    @Override
    public ExternalCollectionTable addCollectionTable(String name) {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.addSelf();
        collectionTable.setName(name);
        return collectionTable;
    }

    @Override
    public ExternalEntityColumn addValueColumn(String columnName) {
        EntityColumn valueColumn = this.buildValueColumn();
        valueColumn.addSelf();
        valueColumn.setName(columnName);
        return valueColumn;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("fetch");
        names.add("access");
        return names;
    }

    private BatchFetch buildBatchFetch() {
        return new BatchFetch(this);
    }

    private CollectionTable buildCollectionTable() {
        return new CollectionTable(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("value-column");
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("collection-table");
        names.add("join-fetch");
        names.add("batch-fetch");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private EntityColumn buildValueColumn() {
        return new EntityColumn(this, "value-column", -1);
    }

    @Override
    public ExternalBatchFetch getBatchFetch() {
        if (this.hasChild("batch-fetch")) {
            return this.buildBatchFetch();
        }
        return null;
    }

    @Override
    public ExternalCollectionTable getCollectionTable() {
        if (this.hasChild("collection-table")) {
            return this.buildCollectionTable();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "basic-collection";
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public JoinFetchType getJoinFetchType() {
        return this.getChildEnumNode("join-fetch", JoinFetchType.class);
    }

    @Override
    public TextRange getJoinFetchTypeTextRange() {
        return this.getChildTextNodeTextRange("join-fetch");
    }

    @Override
    public ExternalEntityColumn getValueColumn() {
        if (this.hasChild("value-column")) {
            return this.buildValueColumn();
        }
        return null;
    }

    @Override
    public void removeBatchFetch() {
        this.removeChild("batch-fetch");
    }

    @Override
    public void removeCollectionTable() {
        CollectionTable collectionTable = this.buildCollectionTable();
        collectionTable.removeSelf();
    }

    @Override
    public void removeValueColumn() {
        EntityColumn valueColumn = this.buildValueColumn();
        valueColumn.removeSelf();
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public void setJoinFetchType(JoinFetchType type) {
        this.updateChildTextNode("join-fetch", (Enum<?>)type);
    }
}

