/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalCache;
import org.eclipse.persistence.tools.mapping.orm.ExternalTimeOfDay;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.mapping.orm.dom.TimeOfDay;
import org.eclipse.persistence.tools.utility.TextRange;

final class Cache
extends AbstractExternalForm
implements ExternalCache {
    Cache(MappedSuperclass parent) {
        super(parent);
    }

    @Override
    public ExternalTimeOfDay addExpiryTimeOfDay() {
        TimeOfDay timeOfDay = this.buildTimeOfDay();
        timeOfDay.addSelf();
        return timeOfDay;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("size");
        names.add("shared");
        names.add("type");
        names.add("always-refresh");
        names.add("refresh-only-if-newer");
        names.add("disable-hits");
        names.add("coordination-type");
        return names;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("expiry");
        names.add("expiry-time-of-day");
        return names;
    }

    private TimeOfDay buildTimeOfDay() {
        return new TimeOfDay(this);
    }

    @Override
    public TextRange getAlwaysRefreshTextRange() {
        return this.getAttributeTextRange("always-refresh");
    }

    @Override
    public CacheCoordinationType getCoordinationType() {
        return this.getEnumAttribute("coordination-type", CacheCoordinationType.class);
    }

    @Override
    public TextRange getCoordinationTypeTextRange() {
        return this.getAttributeTextRange("coordination-type");
    }

    @Override
    public DatabaseChangeNotificationType getDatabaseChangeNotificationType() {
        return this.getEnumAttribute("database-change-notification-type", DatabaseChangeNotificationType.class);
    }

    @Override
    public TextRange getDatabaseChangeNotificationTypeTextRange() {
        return this.getAttributeTextRange("database-change-notification-type");
    }

    @Override
    public TextRange getDisableHitsTextRange() {
        return this.getAttributeTextRange("disable-hits");
    }

    @Override
    protected String getElementName() {
        return "cache";
    }

    @Override
    public ExternalTimeOfDay getExpiryTimeOfDay() {
        if (this.hasExpiryTimeOfDay()) {
            return this.buildTimeOfDay();
        }
        return null;
    }

    @Override
    public TextRange getExpiryTimeOfDayTextRange() {
        return this.getChildTextRange("expiry-time-of-day");
    }

    @Override
    public Integer getExpiryTimeToLive() {
        return this.getChildIntegerNode("expiry");
    }

    @Override
    public TextRange getExpiryTimeToLiveTextRange() {
        return this.getChildTextNodeTextRange("expiry");
    }

    @Override
    public CacheIsolationType getIsolationType() {
        return this.getEnumAttribute("isolation", CacheIsolationType.class);
    }

    @Override
    public TextRange getIsolationTypeTextRange() {
        return this.getAttributeTextRange("isolation");
    }

    @Override
    public TextRange getRefreshOnlyIfNewerTextRange() {
        return this.getAttributeTextRange("refresh-only-if-newer");
    }

    @Override
    public TextRange getSharedTextRange() {
        return this.getAttributeTextRange("shared");
    }

    @Override
    public Integer getSize() {
        return this.getIntegerAttribute("size");
    }

    @Override
    public TextRange getSizeTextRange() {
        return this.getAttributeTextRange("size");
    }

    @Override
    public CacheType getType() {
        return this.getEnumAttribute("type", CacheType.class);
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.getAttributeTextRange("type");
    }

    @Override
    public boolean hasExpiryTimeOfDay() {
        return this.hasChild("expiry-time-of-day");
    }

    @Override
    public Boolean isAlwaysRefresh() {
        return this.getBooleanAttribute("always-refresh");
    }

    @Override
    public Boolean isDisableHits() {
        return this.getBooleanAttribute("disable-hits");
    }

    @Override
    public Boolean isRefreshOnlyIfNewer() {
        return this.getBooleanAttribute("refresh-only-if-newer");
    }

    @Override
    public Boolean isShared() {
        return this.getBooleanAttribute("shared");
    }

    @Override
    public void removeExpiryTimeOfDay() {
        TimeOfDay timeOfDay = this.buildTimeOfDay();
        timeOfDay.removeSelf();
        if (!this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.setAttribute("always-refresh", alwaysRefresh);
        if (alwaysRefresh == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setCoordinationType(CacheCoordinationType type) {
        this.setAttribute("coordination-type", (Enum<?>)type);
        if (type == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setDatabaseChangeNotificationType(DatabaseChangeNotificationType type) {
        this.setAttribute("database-change-notification-type", (Enum<?>)type);
        if (type == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setDisableHits(Boolean disableHits) {
        this.setAttribute("disable-hits", disableHits);
        if (disableHits == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setExpiryTimeToLive(Integer timeToLive) {
        this.updateChildTextNode("expiry", timeToLive);
        if (timeToLive == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setIsolationType(CacheIsolationType isolationType) {
        this.setAttribute("isolation", (Enum<?>)isolationType);
        if (isolationType == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer) {
        this.setAttribute("refresh-only-if-newer", refreshOnlyIfNewer);
        if (refreshOnlyIfNewer == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setShared(Boolean shared) {
        this.setAttribute("shared", shared);
        if (shared == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setSize(Integer size) {
        this.setAttribute("size", size);
        if (size == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }

    @Override
    public void setType(CacheType type) {
        this.setAttribute("type", (Enum<?>)type);
        if (type == null && !this.hasAnything()) {
            this.removeSelf();
        }
    }
}

