/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalFieldResult;
import org.eclipse.persistence.tools.mapping.orm.dom.FieldResult;
import org.eclipse.persistence.tools.mapping.orm.dom.SQLResultSetMapping;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class EntityResult
extends AbstractExternalForm
implements ExternalEntityResult {
    private int index;

    EntityResult(SQLResultSetMapping parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalFieldResult addFieldResult(String name) {
        FieldResult fieldResult = this.buildFieldResult(-1);
        fieldResult.addSelf();
        fieldResult.setName(name);
        return fieldResult;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("entity-class");
        names.add("discriminator-column");
        return names;
    }

    private FieldResult buildFieldResult(int index) {
        return new FieldResult(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public List<ExternalFieldResult> fieldResults() {
        int count = this.fieldResultsSize();
        ArrayList<ExternalFieldResult> fieldResults = new ArrayList<ExternalFieldResult>(count);
        int index = 0;
        while (index < count) {
            fieldResults.add(this.buildFieldResult(index));
            ++index;
        }
        return fieldResults;
    }

    @Override
    public int fieldResultsSize() {
        return this.getChildrenSize("field-result");
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.getAttribute("discriminator-column");
    }

    @Override
    public TextRange getDiscriminatorColumnNameTextRange() {
        return this.getAttributeTextRange("discriminator-column");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "entity-result";
    }

    @Override
    public String getEntityClassName() {
        return this.getAttribute("entity-class");
    }

    @Override
    public TextRange getEntityClassNameTextRange() {
        return this.getAttributeTextRange("entity-class");
    }

    @Override
    public ExternalFieldResult getFieldResult(int index) {
        if (this.hasChild("field-result", index)) {
            return this.buildFieldResult(index);
        }
        return null;
    }

    @Override
    public void removeFieldResult(int index) {
        FieldResult fieldResult = this.buildFieldResult(index);
        fieldResult.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDiscriminatorColumnName(String name) {
        this.setAttribute("discriminator-column", name);
    }

    @Override
    public void setEntityClassName(String className) {
        this.setAttribute("entity-class", className);
    }
}

