/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalIDMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;
import org.eclipse.persistence.tools.utility.TextRange;

final class IdMapping
extends ConvertibleMapping
implements ExternalIDMapping {
    IdMapping(MappedSuperclass parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalEntityColumn addColumn() {
        EntityColumn column = this.buildColumn();
        column.addSelf();
        return column;
    }

    @Override
    public ExternalEntityIDGeneratedValue addGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.addSelf();
        return generatedValue;
    }

    @Override
    public ExternalSequenceGenerator addSequenceGenerator() {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator();
        sequenceGenerator.addSelf();
        return sequenceGenerator;
    }

    @Override
    public ExternalTableGenerator addTableGenerator() {
        TableGenerator tableGenerator = this.buildTableGenerator();
        tableGenerator.addSelf();
        return tableGenerator;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("access");
        names.add("mutable");
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this, "column", -1);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("field");
        names.add("generated-value");
        names.add("temporal");
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("table-generator");
        names.add("sequence-generator");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    private EntityIDGeneratedValue buildGeneratedValue() {
        return new EntityIDGeneratedValue(this);
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    private SequenceGenerator buildSequenceGenerator() {
        return new SequenceGenerator(this, -1);
    }

    private TableGenerator buildTableGenerator() {
        return new TableGenerator(this, -1);
    }

    @Override
    public EntityColumn getColumn() {
        if (this.hasChild("column")) {
            return this.buildColumn();
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "id";
    }

    @Override
    public ExternalEntityIDGeneratedValue getGeneratedValue() {
        if (this.hasChild("generated-value")) {
            return this.buildGeneratedValue();
        }
        return null;
    }

    @Override
    public TextRange getMutableTextRange() {
        return this.getAttributeTextRange("mutable");
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator() {
        if (this.hasChild("sequence-generator")) {
            return this.buildSequenceGenerator();
        }
        return null;
    }

    @Override
    public ExternalTableGenerator getTableGenerator() {
        if (this.hasChild("table-generator")) {
            return this.buildTableGenerator();
        }
        return null;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode("temporal", TemporalType.class);
    }

    @Override
    public TextRange getTemporalTypeTextRange() {
        return this.getChildTextNodeTextRange("temporal");
    }

    @Override
    public boolean hasColumn() {
        return this.hasChild("column");
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute("mutable");
    }

    @Override
    public void removeColumn() {
        EntityColumn column = this.buildColumn();
        column.removeSelf();
    }

    @Override
    public void removeGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.removeSelf();
    }

    @Override
    public void removeSequenceGenerator() {
        SequenceGenerator generator = this.buildSequenceGenerator();
        generator.removeSelf();
    }

    @Override
    public void removeTableGenerator() {
        TableGenerator generator = this.buildTableGenerator();
        generator.removeSelf();
    }

    @Override
    public void setColumn(String columnName) {
        EntityColumn column = this.getColumn();
        if (column == null && columnName == null) {
            return;
        }
        if (column == null && columnName != null) {
            column = this.buildColumn();
            column.addSelf();
        }
        if (columnName != null) {
            column.setName(columnName);
        } else {
            ((AbstractExternalForm)column).removeSelf();
        }
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute("mutable", mutable);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }

    @Override
    public void setSequenceGenerator(String generatorName) {
        this.updateChildTextNode("sequence-generator", generatorName);
    }

    @Override
    public void setTableGenerator(String generatorName) {
        this.updateChildTextNode("table-generator", generatorName);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode("temporal", (Enum<?>)type);
    }
}

