/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalFormHelper;
import org.eclipse.persistence.tools.mapping.orm.AccessType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalClassConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalEmbeddable;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappedSuperClass;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ClassConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedNativeQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.NamedStoredProcedureQuery;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.PersistenceUnit;
import org.eclipse.persistence.tools.mapping.orm.dom.SQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.StructConverter;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.TypeConverter;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

public final class ORMConfiguration
extends AbstractExternalForm
implements ExternalORMConfiguration {
    private final ExternalFormHelper helper;

    public ORMConfiguration(ExternalFormHelper helper) {
        super(null);
        this.helper = helper;
    }

    @Override
    public ExternalClassConverter addConverter() {
        ClassConverter converter = this.buildConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public ExternalTenantDiscriminatorColumn addDiscriminatorColumn() {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(-1);
        column.addSelf();
        return column;
    }

    @Override
    public ExternalEmbeddable addEmbeddable(String className) {
        Embeddable embeddable = this.buildEmbeddable(-1);
        embeddable.addSelf();
        embeddable.setClassName(className);
        return embeddable;
    }

    @Override
    public ExternalEntity addEntity(String className) {
        Entity entity = this.buildEntity(-1);
        entity.addSelf();
        entity.setClassName(className);
        return entity;
    }

    @Override
    public ExternalMappedSuperClass addMappedSuperClass(String className) {
        MappedSuperclass mappedSuperclass = this.buildMappedSuperclass(-1);
        mappedSuperclass.addSelf();
        mappedSuperclass.setClassName(className);
        return mappedSuperclass;
    }

    @Override
    public ExternalNativeQuery addNamedNativeQuery(String name) {
        NamedNativeQuery query = this.buildNamedNativeQuery(-1);
        query.addSelf();
        query.setName(name);
        return query;
    }

    @Override
    public ExternalBasicNamedQuery addNamedQuery(String name) {
        NamedQuery query = this.buildNamedQuery(-1);
        query.addSelf();
        query.setName(name);
        return query;
    }

    @Override
    public ExternalNamedStoredProcedureQuery addNamedStoredProcedureQuery(String name) {
        NamedStoredProcedureQuery query = this.buildStoredProcedureQuery(-1);
        query.addSelf();
        query.setName(name);
        return query;
    }

    @Override
    public ExternalObjectTypeConverter addObjectTypeConverter() {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public ExternalPersistenceUnit addPersistenceUnitMetaData() {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit();
        persistenceUnit.addSelf();
        return persistenceUnit;
    }

    @Override
    protected Element addSelf(String elementName) {
        return this.addSelf(elementName, Collections.<String>emptyList());
    }

    @Override
    public Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.helper.buildORMConfiguration(this);
    }

    @Override
    public ExternalSequenceGenerator addSequenceGenerator(String name) {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator(-1);
        sequenceGenerator.addSelf();
        sequenceGenerator.setName(name);
        return sequenceGenerator;
    }

    @Override
    public ExternalSQLResultSetMapping addSqlResultSetMapping(String name) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(-1);
        sqlResultSetMapping.addSelf();
        sqlResultSetMapping.setName(name);
        return sqlResultSetMapping;
    }

    @Override
    public ExternalStructConverter addStructConverter() {
        StructConverter converter = this.buildStructConverter(-1);
        converter.addSelf();
        return converter;
    }

    @Override
    public ExternalTableGenerator addTableGenerator(String name) {
        TableGenerator generator = this.buildTableGenerator(-1);
        generator.addSelf();
        generator.setName(name);
        return generator;
    }

    @Override
    public ExternalTypeConverter addTypeConverter() {
        TypeConverter converter = this.buildTypeConverter(-1);
        converter.addSelf();
        return converter;
    }

    private ClassConverter buildConverter(int index) {
        return new ClassConverter(this, index);
    }

    private TenantDiscriminatorColumn buildDiscriminatorColumn(int index) {
        return new TenantDiscriminatorColumn(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("persistence-unit-metadata");
        names.add("package");
        names.add("schema");
        names.add("catalog");
        names.add("access");
        names.add("access-methods");
        names.add("tenant-discriminator-column");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("serialized-converter");
        names.add("struct-converter");
        names.add("sequence-generator");
        names.add("table-generator");
        names.add("uuid-generator");
        names.add("partitioning");
        names.add("replication-partitioning");
        names.add("round-robin-partitioning");
        names.add("pinned-partitioning");
        names.add("range-partitioning");
        names.add("value-partitioning");
        names.add("hash-partitioning");
        names.add("union-partitioning");
        names.add("named-query");
        names.add("named-native-query");
        names.add("named-stored-procedure-query");
        names.add("named-stored-function-query");
        names.add("named-plsql-stored-procedure-query");
        names.add("named-plsql-stored-function-query");
        names.add("oracle-object");
        names.add("oracle-array");
        names.add("plsql-record");
        names.add("plsql-table");
        names.add("sql-result-set-mapping");
        names.add("mapped-superclass");
        names.add("entity");
        names.add("embeddable");
        return names;
    }

    private Embeddable buildEmbeddable(int index) {
        return new Embeddable(this, index);
    }

    private Entity buildEntity(int index) {
        return new Entity(this, index);
    }

    private MappedSuperclass buildMappedSuperclass(int index) {
        return new MappedSuperclass(this, index);
    }

    private NamedNativeQuery buildNamedNativeQuery(int index) {
        return new NamedNativeQuery(this, index);
    }

    private NamedQuery buildNamedQuery(int index) {
        return new NamedQuery(this, index);
    }

    private ObjectTypeConverter buildObjectTypeConverter(int index) {
        return new ObjectTypeConverter(this, index);
    }

    private PersistenceUnit buildPersistenceUnit() {
        return new PersistenceUnit(this);
    }

    public String buildSchemaLocation(ORMDocumentType version) {
        StringBuilder sb = new StringBuilder();
        sb.append(version.getXmlNamespace());
        sb.append(" ");
        sb.append(version.getSchemaURI());
        return sb.toString();
    }

    private SequenceGenerator buildSequenceGenerator(int index) {
        return new SequenceGenerator(this, index);
    }

    private SQLResultSetMapping buildSqlResultSetMapping(int index) {
        return new SQLResultSetMapping(this, index);
    }

    private NamedStoredProcedureQuery buildStoredProcedureQuery(int index) {
        return new NamedStoredProcedureQuery(this, index);
    }

    private StructConverter buildStructConverter(int index) {
        return new StructConverter(this, index);
    }

    private TableGenerator buildTableGenerator(int index) {
        return new TableGenerator(this, index);
    }

    private TypeConverter buildTypeConverter(int index) {
        return new TypeConverter(this, index);
    }

    @Override
    public List<ExternalClassConverter> converters() {
        int count = this.convertersSize();
        ArrayList<ExternalClassConverter> converters = new ArrayList<ExternalClassConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public int convertersSize() {
        return this.getChildrenSize("converter");
    }

    @Override
    public List<ExternalTenantDiscriminatorColumn> discriminatorColumns() {
        int count = this.discriminatorColumnSize();
        ArrayList<ExternalTenantDiscriminatorColumn> columns = new ArrayList<ExternalTenantDiscriminatorColumn>(count);
        int index = 0;
        while (index < count) {
            columns.add(this.buildDiscriminatorColumn(index));
            ++index;
        }
        return columns;
    }

    @Override
    public int discriminatorColumnSize() {
        return this.getChildrenSize("tenant-discriminator-column");
    }

    @Override
    public List<ExternalEmbeddable> embeddables() {
        int count = this.embeddablesSize();
        ArrayList<ExternalEmbeddable> embeddables = new ArrayList<ExternalEmbeddable>(count);
        int index = 0;
        while (index < count) {
            embeddables.add(this.buildEmbeddable(index));
            ++index;
        }
        return embeddables;
    }

    @Override
    public int embeddablesSize() {
        return this.getChildrenSize("embeddable");
    }

    @Override
    public List<ExternalEntity> entities() {
        int count = this.entitiesSize();
        ArrayList<ExternalEntity> entities = new ArrayList<ExternalEntity>(count);
        int index = 0;
        while (index < count) {
            entities.add(this.buildEntity(index));
            ++index;
        }
        return entities;
    }

    @Override
    public int entitiesSize() {
        return this.getChildrenSize("entity");
    }

    @Override
    public AccessType getAccessType() {
        return this.getChildEnumNode("access", AccessType.class);
    }

    @Override
    public TextRange getAccessTypeTextRange() {
        return this.getChildTextNodeTextRange("access");
    }

    @Override
    public String getBuildVersion() {
        return "2.0";
    }

    @Override
    public String getCatalogName() {
        return this.getChildTextNode("catalog");
    }

    @Override
    public TextRange getCatalogNameTextRange() {
        return this.getChildTextNodeTextRange("catalog");
    }

    @Override
    public ExternalClassConverter getConverter(int index) {
        if (this.hasChild("converter", index)) {
            return this.buildConverter(index);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index) {
        if (this.hasChild("tenant-discriminator-column", index)) {
            return this.buildDiscriminatorColumn(index);
        }
        return null;
    }

    @Override
    public ORMDocumentType getDocumentType() {
        return ORMDocumentType.value(this.getNamespace(), this.getVersion(), this.getSchemaLocation());
    }

    @Override
    public Element getElement() {
        return this.getRootElement();
    }

    @Override
    public String getElementName() {
        return "entity-mappings";
    }

    @Override
    public ExternalEmbeddable getEmbeddable(int index) {
        if (this.hasChild("embeddable", index)) {
            return this.buildEmbeddable(index);
        }
        return null;
    }

    @Override
    public ExternalEmbeddable getEmbeddable(String className) {
        for (ExternalEmbeddable embeddable : this.embeddables()) {
            if (!ObjectTools.equals((Object)embeddable.getClassName(), (Object)className)) continue;
            return embeddable;
        }
        return null;
    }

    @Override
    public ExternalEntity getEntity(int index) {
        if (this.hasChild("entity", index)) {
            return this.buildEntity(index);
        }
        return null;
    }

    @Override
    public Entity getEntity(String className) {
        for (ExternalEntity entity : this.entities()) {
            if (!ObjectTools.equals((Object)entity.getClassName(), (Object)className)) continue;
            return (Entity)entity;
        }
        return null;
    }

    @Override
    protected ExternalFormHelper getHelper() {
        return this.helper;
    }

    @Override
    public URL getLocation() {
        return this.helper.getLocation();
    }

    @Override
    public ExternalMappedSuperClass getMappedSuperClass(int index) {
        if (this.hasChild("mapped-superclass", index)) {
            return this.buildMappedSuperclass(index);
        }
        return null;
    }

    @Override
    public ExternalMappedSuperClass getMappedSuperClass(String className) {
        for (ExternalMappedSuperClass entity : this.mappedSuperClasses()) {
            if (!ObjectTools.equals((Object)entity.getClassName(), (Object)className)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public ExternalNativeQuery getNamedNativeQuery(int index) {
        if (this.hasChild("named-native-query", index)) {
            return this.buildNamedNativeQuery(index);
        }
        return null;
    }

    @Override
    public ExternalNativeQuery getNamedNativeQuery(String queryName) {
        for (ExternalNativeQuery namedQuery : this.namedNativeQueries()) {
            if (!namedQuery.getName().equals(queryName)) continue;
            return namedQuery;
        }
        return null;
    }

    @Override
    public ExternalBasicNamedQuery getNamedQuery(int index) {
        if (this.hasChild("named-query", index)) {
            return this.buildNamedQuery(index);
        }
        return null;
    }

    @Override
    public NamedQuery getNamedQuery(String queryName) {
        for (ExternalNamedQuery externalNamedQuery : this.namedQueries()) {
            if (!externalNamedQuery.getName().equals(queryName)) continue;
            return (NamedQuery)externalNamedQuery;
        }
        return null;
    }

    @Override
    public ExternalNamedStoredProcedureQuery getNamedStoredProcedureQuery(int index) {
        if (this.hasChild("named-stored-procedure-query", index)) {
            return this.buildStoredProcedureQuery(index);
        }
        return null;
    }

    @Override
    public ExternalObjectTypeConverter getObjectTypeConverter(int index) {
        if (this.hasChild("object-type-converter", index)) {
            return this.buildObjectTypeConverter(index);
        }
        return null;
    }

    @Override
    public String getPackageName() {
        return this.getChildTextNode("package");
    }

    @Override
    public TextRange getPackageNameTextRange() {
        return this.getChildTextNodeTextRange("package");
    }

    @Override
    public PersistenceUnit getPersistenceUnitMetaData() {
        if (this.hasChild("persistence-unit-metadata")) {
            return this.buildPersistenceUnit();
        }
        return null;
    }

    @Override
    public TextRange getRootElementTextRange() {
        return this.getElementNameTextRange(this.getRootElement());
    }

    @Override
    public String getSchemaName() {
        return this.getChildTextNode("schema");
    }

    @Override
    public TextRange getSchemaNameTextRange() {
        return this.getChildTextNodeTextRange("schema");
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator(int index) {
        if (this.hasChild("sequence-generator", index)) {
            return this.buildSequenceGenerator(index);
        }
        return null;
    }

    @Override
    public URL getSourceRoot() {
        return this.getHelper().getSourceRoot();
    }

    @Override
    public ExternalSQLResultSetMapping getSqlResultSetMapping(int index) {
        if (this.hasChild("sql-result-set-mapping", index)) {
            return this.buildSqlResultSetMapping(index);
        }
        return null;
    }

    @Override
    public ExternalStructConverter getStructConverter(int index) {
        if (this.hasChild("struct-converter", index)) {
            return this.buildStructConverter(index);
        }
        return null;
    }

    @Override
    public ExternalTableGenerator getTableGenerator(int index) {
        if (this.hasChild("table-generator", index)) {
            return this.buildTableGenerator(index);
        }
        return null;
    }

    @Override
    public ExternalTypeConverter getTypeConverter(int index) {
        if (this.hasChild("type-converter", index)) {
            return this.buildTypeConverter(index);
        }
        return null;
    }

    @Override
    public String getXML() {
        try {
            this.acquireReadLock();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.getDocument());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
            String string = output.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean hasPersistenceUnitMetaData() {
        return this.hasChild("persistence-unit-metadata");
    }

    @Override
    public List<ExternalMappedSuperClass> mappedSuperClasses() {
        int count = this.mappedSuperClassesSize();
        ArrayList<ExternalMappedSuperClass> mappedSuperclasses = new ArrayList<ExternalMappedSuperClass>(count);
        int index = 0;
        while (index < count) {
            mappedSuperclasses.add(this.buildMappedSuperclass(index));
            ++index;
        }
        return mappedSuperclasses;
    }

    @Override
    public int mappedSuperClassesSize() {
        return this.getChildrenSize("mapped-superclass");
    }

    @Override
    public List<ExternalNativeQuery> namedNativeQueries() {
        int count = this.namedNativeQueriesSize();
        ArrayList<ExternalNativeQuery> nativeQueries = new ArrayList<ExternalNativeQuery>(count);
        int index = 0;
        while (index < count) {
            nativeQueries.add(this.buildNamedNativeQuery(index));
            ++index;
        }
        return nativeQueries;
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.getChildrenSize("named-native-query");
    }

    @Override
    public List<ExternalBasicNamedQuery> namedQueries() {
        int count = this.namedQueriesSize();
        ArrayList<ExternalBasicNamedQuery> namedQueries = new ArrayList<ExternalBasicNamedQuery>(count);
        int index = 0;
        while (index < count) {
            namedQueries.add(this.buildNamedQuery(index));
            ++index;
        }
        return namedQueries;
    }

    @Override
    public int namedQueriesSize() {
        return this.getChildrenSize("named-query");
    }

    @Override
    public List<ExternalObjectTypeConverter> objectTypeConverters() {
        int count = this.objectTypeConvertersSize();
        ArrayList<ExternalObjectTypeConverter> converters = new ArrayList<ExternalObjectTypeConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildObjectTypeConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public int objectTypeConvertersSize() {
        return this.getChildrenSize("object-type-converter");
    }

    @Override
    public void removeConverter(int index) {
        ClassConverter converter = this.buildConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removeDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
        ((AbstractExternalForm)column).removeSelf();
    }

    @Override
    public void removeEmbeddable(int index) {
        Embeddable entity = this.buildEmbeddable(index);
        entity.removeSelf();
    }

    @Override
    public void removeEntity(int index) {
        Entity entity = this.buildEntity(index);
        entity.removeSelf();
    }

    @Override
    public void removeEntity(String entityClassName) {
        Entity entity = this.getEntity(entityClassName);
        if (entity != null) {
            entity.removeSelf();
        }
    }

    @Override
    public void removeMappedSuperClass(int index) {
        MappedSuperclass entity = this.buildMappedSuperclass(index);
        entity.removeSelf();
    }

    @Override
    public void removeNamedQuery(int index) {
        NamedQuery namedQuery = this.buildNamedQuery(index);
        namedQuery.removeSelf();
    }

    @Override
    public void removeNamedQuery(String queryName) {
        NamedQuery query = this.getNamedQuery(queryName);
        if (query != null) {
            query.removeSelf();
        }
    }

    @Override
    public void removeNativeQuery(int index) {
        NamedNativeQuery namedNativeQuery = this.buildNamedNativeQuery(index);
        namedNativeQuery.removeSelf();
    }

    @Override
    public void removeObjectTypeConverter(int index) {
        ObjectTypeConverter converter = this.buildObjectTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removePersistenceUnitMetaData() {
        PersistenceUnit persistenceUnit = this.buildPersistenceUnit();
        persistenceUnit.removeSelf();
    }

    @Override
    public void removeSequenceGenerator(int index) {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator(index);
        sequenceGenerator.removeSelf();
    }

    @Override
    public void removeSqlResultSetMapping(int index) {
        SQLResultSetMapping sqlResultSetMapping = this.buildSqlResultSetMapping(index);
        sqlResultSetMapping.removeSelf();
    }

    @Override
    public void removeStoredProcedureQuery(int index) {
        NamedStoredProcedureQuery storedProcedureQuery = this.buildStoredProcedureQuery(index);
        storedProcedureQuery.removeSelf();
    }

    @Override
    public void removeStructConverter(int index) {
        StructConverter converter = this.buildStructConverter(index);
        converter.removeSelf();
    }

    @Override
    public void removeTableGenerator(int index) {
        TableGenerator tableGenerator = this.buildTableGenerator(index);
        tableGenerator.removeSelf();
    }

    @Override
    public void removeTypeConverter(int index) {
        TypeConverter converter = this.buildTypeConverter(index);
        converter.removeSelf();
    }

    @Override
    public List<ExternalSequenceGenerator> sequenceGenerators() {
        int count = this.sequenceGeneratorsSize();
        ArrayList<ExternalSequenceGenerator> generators = new ArrayList<ExternalSequenceGenerator>(count);
        int index = 0;
        while (index < count) {
            generators.add(this.buildSequenceGenerator(index));
            ++index;
        }
        return generators;
    }

    @Override
    public int sequenceGeneratorsSize() {
        return this.getChildrenSize("sequence-generator");
    }

    @Override
    public void setAccessType(AccessType type) {
        this.updateChildTextNode("access", type);
    }

    @Override
    public void setCatalogName(String catalog) {
        this.updateChildTextNode("catalog", catalog);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setDocumentType(ORMDocumentType version) {
        this.setVersion(version.getVersion());
        this.setSchemaLocation(this.buildSchemaLocation(version));
    }

    @Override
    public void setPackageName(String packageName) {
        this.updateChildTextNode("package", packageName);
    }

    @Override
    public void setSchemaName(String schema) {
        this.updateChildTextNode("schema", schema);
    }

    @Override
    public List<ExternalSQLResultSetMapping> sqlResultSetMappings() {
        int count = this.sqlResultSetMappingsSize();
        ArrayList<ExternalSQLResultSetMapping> sqlResultSetMappings = new ArrayList<ExternalSQLResultSetMapping>(count);
        int index = 0;
        while (index < count) {
            sqlResultSetMappings.add(this.buildSqlResultSetMapping(index));
            ++index;
        }
        return sqlResultSetMappings;
    }

    @Override
    public int sqlResultSetMappingsSize() {
        return this.getChildrenSize("sql-result-set-mapping");
    }

    @Override
    public List<ExternalNamedStoredProcedureQuery> storedProcedureQueries() {
        int count = this.storedProcedureQueriesSize();
        ArrayList<ExternalNamedStoredProcedureQuery> storedProcedureQueries = new ArrayList<ExternalNamedStoredProcedureQuery>(count);
        int index = 0;
        while (index < count) {
            storedProcedureQueries.add(this.buildStoredProcedureQuery(index));
            ++index;
        }
        return storedProcedureQueries;
    }

    @Override
    public int storedProcedureQueriesSize() {
        return this.getChildrenSize("named-stored-procedure-query");
    }

    @Override
    public List<ExternalStructConverter> structConverters() {
        int count = this.structConvertersSize();
        ArrayList<ExternalStructConverter> converters = new ArrayList<ExternalStructConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildStructConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public int structConvertersSize() {
        return this.getChildrenSize("struct-converter");
    }

    @Override
    public List<ExternalTableGenerator> tableGenerators() {
        int count = this.tableGeneratorsSize();
        ArrayList<ExternalTableGenerator> generators = new ArrayList<ExternalTableGenerator>(count);
        int index = 0;
        while (index < count) {
            generators.add(this.buildTableGenerator(index));
            ++index;
        }
        return generators;
    }

    @Override
    public int tableGeneratorsSize() {
        return this.getChildrenSize("table-generator");
    }

    @Override
    public List<ExternalTypeConverter> typeConverters() {
        int count = this.typeConvertersSize();
        ArrayList<ExternalTypeConverter> converters = new ArrayList<ExternalTypeConverter>(count);
        int index = 0;
        while (index < count) {
            converters.add(this.buildTypeConverter(index));
            ++index;
        }
        return converters;
    }

    @Override
    public int typeConvertersSize() {
        return this.getChildrenSize("type-converter");
    }
}

