/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.persistence.tools.mapping.DefaultFormHelper;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMRepository;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.w3c.dom.Document;

public final class ORMRepository
implements ExternalORMRepository {
    private DocumentBuilder buildDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        return factory.newDocumentBuilder();
    }

    @Override
    public ORMConfiguration buildORMConfiguration(URL location, ORMDocumentType docType) throws IOException {
        DefaultFormHelper helper = new DefaultFormHelper(XMLTools.newDocument(), location);
        ORMConfiguration ormConfiguration = new ORMConfiguration(helper);
        ormConfiguration.setDocumentType(docType);
        return ormConfiguration;
    }

    public ORMConfiguration getORMConfiguration(String ormXML) {
        try {
            Document document = this.buildDocumentBuilder().parse(new ByteArrayInputStream(ormXML.getBytes("utf-8")));
            DefaultFormHelper helper = new DefaultFormHelper(document, null);
            return new ORMConfiguration(helper);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ORMConfiguration getORMConfiguration(URL location) {
        InputStream inputStream = null;
        try {
            inputStream = location.openStream();
            Document document = this.buildDocumentBuilder().parse(inputStream);
            DefaultFormHelper helper = new DefaultFormHelper(document, location);
            ORMConfiguration oRMConfiguration = new ORMConfiguration(helper);
            return oRMConfiguration;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Iterable<URL> ormConfigurationLocations() {
        return EmptyIterable.instance();
    }
}

