/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.collection;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * decentralize test creation code
 */
public class CommonUtilityCollectionTests {

	public static Test suite() {
		TestSuite suite = new TestSuite(CommonUtilityCollectionTests.class.getPackage().getName());

		suite.addTestSuite(ArrayQueueTests.class);
		suite.addTestSuite(ArrayStackTests.class);
		suite.addTestSuite(BagTests.class);
		suite.addTestSuite(CollectionToolsTests.class);
		suite.addTestSuite(HashBagTests.class);
		suite.addTestSuite(IdentityHashBagTests.class);
		suite.addTestSuite(LinkedQueueTests.class);
		suite.addTestSuite(LinkedStackTests.class);
		suite.addTestSuite(ListToolsTests.class);
		suite.addTestSuite(NullElementListTests.class);
		suite.addTestSuite(RepeatingElementListTests.class);
		suite.addTestSuite(SynchronizedQueueTests.class);
		suite.addTestSuite(SynchronizedStackTests.class);

		return suite;
	}

	private CommonUtilityCollectionTests() {
		super();
		throw new UnsupportedOperationException();
	}
}