/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.model.spi;

/**
 * Interface describing the meta-data describing a database column.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see ExternalTable
 * @version 2.6
 */
public interface ExternalColumn {

	/**
	 * Returns the JDBC type code for the column's datatype
	 * (e.g. java.sql.Types.VARCHAR).
	 */
	int getJDBCTypeCode();

	/**
	 * Returns the column's unqualified name.
	 */
	String getName();

	/**
	 * Returns the column's scale. If the column does not have a scale
	 * Returns zero. Typically a column defined as a decimal numeric
	 * datatype will have a scale.
	 */
	int getScale();

	/**
	 * Returns the column's size. If the column does not have a size
	 * Returns zero.
	 */
	int getSize();

	/**
	 * Returns the name of the column's platform-specific datatype
	 * (e.g. "VARCHAR2").
	 */
	String getTypeName();

	/**
	 * Returns whether the column allows null.
	 */
	boolean isNullable();

	/**
	 * Returns whether the column is part of the table's primary key.
	 */
	boolean isPrimaryKey();
}