/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.model.spi;

/**
 * This defines a common interface for all the tables (internal, external, and user-defined)
 * so they can be consolidated whenever necessary (e.g. in the UI choosers).
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
public interface TableDescription {

	/**
	 * Returns any additional information about the table represented by this <code>TableDescription</code>,
	 * as a string. This information can be used to differentiate among <code>TableDescription</code>
	 * objects that might have the same name.
	 */
	String getAdditionalInfo();

	/**
	 * Returns the table's "catalog" name.
	 */
	String getCatalogName();

	/**
	 * Returns the table's unqualified name.
	 */
	String getName();

	/**
	 * Returns the table's fully-qualified name, typically in the form "catalog.schema.name".
	 */
	String getQualifiedName();

	/**
	 * Returns the table's "schema" name.
	 */
	String getSchemaName();
}