/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface describes the configurable properties for an association override in the ORM xml.
 * An association override can be declared at the root entity level.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.AssociationOverride
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalAssociationOverride extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String ASSOCIATION_OVERRIDE = "association-override";

	/**
	 * The element name of the child text node for the description.
	 */
	String DESCRIPTION = "description";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * Adds a join column with the given name.
	 */
	ExternalJoinColumn addJoinColumn(String name);

	/**
	 * Creates new join table for this relationship mapping replacing the old one.
	 */
	ExternalJoinTable addJoinTable(String tableName);

	/**
	 * Returns the description of the attribute override.
	 */
	String getDescription();

	/**
	 * Returns the join column with the given name.
	 */
	ExternalJoinColumn getJoinColumn(int index);

	/**
	 * Returns the join table definition for this relationship mapping.
	 */
	ExternalJoinTable getJoinTable();

	/**
	 * Returns the name of this association override.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} of this association override's name.
	 */
	TextRange getNameTextRange();

	/**
	 * Returns the join columns for this association override.
	 */
	List<ExternalJoinColumn> joinColumns();

	/**
	 * Returns the count of all the join columns for this association override.
	 */
	int joinColumnsSize();

	/**
	 * Removes the join column named.
	 */
	void removeJoinColumn(int index);

	/**
	 * Set the description.
	 */
	void setDescription(String description);

	/**
	 * Sets the name of the association override.
	 */
	void setName(String name);
}