/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * The external form of {@link org.eclipse.persistence.nosql.annotations.JoinField JoinField}.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalNoSqlJoinField extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String JOIN_FIELD = "join-field";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the referenced field name property.
	 */
	String REFERENCED_FIELD_NAME = "referenced-field-name";

	/**
	 * Returns the name of the foreign key/id reference field in the source record.
	 */
	String getName();

	/**
	 * Returns the name of the ID field in the target record.
	 */
	String getReferencedFieldName();

	/**
	 * Sets the name of the foreign key/id reference field in the source record.
	 */
	void setName(String name);

	/**
	 * Sets the name of the ID field in the target record.
	 */
	void setReferencedFieldName(String name);
}