/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.io.IOException;
import java.net.URL;

/**
 * External repository contract for accessing ORM.xml meta data from inside the MW model.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
public interface ExternalORMRepository {

	/**
	 * Creates an ORM configuration and the given location and returns the external representation of it.
	 */
	ExternalORMConfiguration buildORMConfiguration(URL location, ORMDocumentType docType) throws IOException;

	/**
	 * Returns an {@link ExternalORMConfiguration} represented by the given ORM.xml's resource path.
	 * The resource path takes the form of that noted in the persistence.xml and is relative to the
	 * root deployment folder (ex: "META-INF/MyOrm.xml"). Implementors of this interface should scan
	 * visible source paths from the root for this file by concatenating the relative path to known
	 * source paths.
	 */
	ExternalORMConfiguration getORMConfiguration(URL location);

	/**
	 * Returns all ORM.xmls' configurations visible to this repository.
	 */
	Iterable<URL> ormConfigurationLocations();
}