/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an object type
 * converter. One or more object type converters can be declared as part of an entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.ObjectTypeConverter
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalObjectTypeConverter extends ExternalTypeConverter {

	/**
	 * The element name used to store and retrieve the default-object-value child text node.
	 */
	String DEFAULT_OBJECT_VALUE = "default-object-value";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String OBJECT_TYPE_CONVERTER = "object-type-converter";

	/**
	 * Adds a conversion value.
	 */
	ExternalConversionValue addConversionValue();

	/**
	 * Returns a list of all conversion values defined for this object type converter definition.
	 */
	List<ExternalConversionValue> conversionValues();

	/**
	 * Returns the count of all conversion values defined for this object type converter definition.
	 */
	int conversionValuesSize();

	/**
	 * Returns the conversion value at the specified index.
	 */
	ExternalConversionValue getConversionValue(int index);

	/**
	 * Returns the default value for this converter.
	 */
	String getDefaultValue();

	/**
	 * Returns the {@link TextRange} for the default value for this converter.
	 */
	TextRange getDefaultValueTextRange();

	/**
	 * Removes all the conversion values owned by this object type converter.
	 */
	void removeAllConversionValue();

	/**
	 * Remove the conversion value at the specified index.
	 */
	void removeConversionValue(int index);

	/**
	 * Sets the default value for this converter.
	 */
	void setDefaultValue(String value);
}