/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Defines in the ORM.xml, how to map a SQL result set to an Entity view-type object. This object
 * represents more of a query then a mapping per se. May be owned by the root of the ORM.xml, an
 * Entity or a MappedSuperClass.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalSQLResultSetMapping extends ExternalForm {

	/**
	 * The element name of the child text node for the description.
	 */
	String DESCRIPTION = "description";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	String NAME = "name";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String SQL_RESULT_SET_MAPPING = "sql-result-set-mapping";

	/**
	 * Adds a column result with the given name.
	 */
	ExternalColumnResult addColumnResult(String name);

	/**
	 * Adds a entity result with the given name.
	 */
	ExternalEntityResult addEntityResult(String className);

	/**
	 * Returns a list of column results.
	 */
	List<ExternalColumnResult> columnResults();

	/**
	 * Returns the count of all the column results.
	 */
	int columnResultsSize();

	/**
	 * Returns a list of entity result sets.
	 */
	List<ExternalEntityResult> entityResults();

	/**
	 * Returns the count of all the entity result sets.
	 */
	int entityResultsSize();

	/**
	 * Returns the column result at the given position.
	 */
	ExternalColumnResult getColumnResult(int index);

	/**
	 * Returns the description of this SQL result set mapping.
	 */
	String getDescription();

	/**
	 * Returns the entity result at the given position.
	 */
	ExternalEntityResult getEntityResult(int index);

	/**
	 * Returns the name of this SQL result set mapping.
	 */
	String getName();

	/**
	 * Returns the {@link TextRange} for the name value.
	 */
	TextRange getNameTextRange();

	/**
	 * Removes the column result named
	 */
	void removeColumnResult(int index);

	/**
	 * Removes the entity result at the given position.
	 */
	void removeEntityResult(int index);

	/**
	 * Set the description.
	 */
	void setDescription(String description);

	/**
	 * Sets the name of this SQL result set mapping.
	 */
	void setName(String name);
}