/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;

/**
 * This interface and inherited behavior describe the configurable properties defined for a
 * secondary table in the ORM xml.  One or more secondary tables can be declared for an entity.
 * The association of a secondary table to the primary table is defined by PK column joins.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.SecondaryTable
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalSecondaryTable extends ExternalEntityTable {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String SECONDARY_TABLE = "secondary-table";

	/**
	 * Adds a primary key join column with the given name.
	 */
	ExternalPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(String name);

	/**
	 * Returns the primary key join column with at the given position.
	 */
	ExternalPrimaryKeyJoinColumn getPrimaryKeyJoinColumn(int index);

	/**
	 * Returns a list of PK column joins that associate this secondary table to the primary table.
	 */
	List<ExternalPrimaryKeyJoinColumn> primaryKeyJoinColumns();

	/**
	 * Returns the count of PK column joins that associate this secondary table to the primary table.
	 */
	int primaryKeyJoinColumnsSize();

	/**
	 * Removes all primary key join columns associated with this secondary table.
	 */
	void removeAllPrimaryKeyJoinColumns();

	/**
	 * Removes the primary key join column at the given position.
	 */
	void removePrimaryKeyJoinColumn(int index);
}