/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * Defines in the ORM.xml a sequence generator that can be used to populate the ID field of an
 * entity. A sequence generator may be defined at the root, ORM level, on an Entity or directly
 * on an Entity's ID definition.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalSequenceGenerator extends ExternalPrimaryKeyGenerator {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String SEQUENCE_GENERATOR = "sequence-generator";

	/**
	 * The attribute name used to store and retrieve the sequence-name property.
	 */
	String SEQUENCE_NAME = "sequence-name";

	/**
	 * Returns the name for the sequence table/artifact to be created or used on the db.
	 */
	String getSequenceName();

	/**
	 * Returns the {@link TextRange} for the name for the sequence table.
	 */
	TextRange getSequenceNameTextRange();

	/**
	 * Set the sequence name.
	 */
	void setSequenceName(String name);
}